<?php if (!function_exists('productStats')) {
  function productStats($context) {
    ?>
    <div class="product-stats">
      <ul class="list-unstyled">
        <?php if ($context['journal3_product_stock']) { ?>
          <li class="product-stock <?php echo $context['journal3_product_stock_class']; ?>"><b><?php echo $context['journal3_product_stock_text']; ?>:</b> <span><?php echo $context['journal3_product_stock_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_manufacturer']) { ?>
          <li class="product-manufacturer"><b><?php echo $context['journal3_product_manufacturer_text']; ?>:</b> <a href="<?php echo $context['journal3_product_manufacturer_href']; ?>"><?php echo $context['journal3_product_manufacturer_value']; ?></a></li>
        <?php } ?>
        <?php if ($context['journal3_product_reward']) { ?>
          <li class="product-reward"><b><?php echo $context['journal3_product_reward_text']; ?>:</b> <span><?php echo $context['journal3_product_reward_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_model']) { ?>
          <li class="product-model"><b><?php echo $context['journal3_product_model_text']; ?>:</b> <span><?php echo $context['journal3_product_model_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_weight']) { ?>
          <li class="product-weight"><b><?php echo $context['journal3_product_weight_text']; ?>:</b> <span><?php echo $context['journal3_product_weight_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_dimensions']) { ?>
          <li class="product-dimension"><b><?php echo $context['journal3_product_dimensions_text']; ?>:</b> <span><?php echo $context['journal3_product_dimensions_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_sku']) { ?>
          <li class="product-sku"><b><?php echo $context['journal3_product_sku_text']; ?>:</b> <span> <?php echo $context['journal3_product_sku_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_upc']) { ?>
          <li class="product-upc"><b><?php echo $context['journal3_product_upc_text']; ?>:</b> <span><?php echo $context['journal3_product_upc_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_ean']) { ?>
          <li class="product-ean"><b><?php echo $context['journal3_product_ean_text']; ?>:</b> <span><?php echo $context['journal3_product_ean_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_jan']) { ?>
          <li class="product-jan"><b><?php echo $context['journal3_product_jan_text']; ?>:</b> <span><?php echo $context['journal3_product_jan_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_isbn']) { ?>
          <li class="product-isbn"><b><?php echo $context['journal3_product_isbn_text']; ?>:</b> <span><?php echo $context['journal3_product_isbn_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_mpn']) { ?>
          <li class="product-mpn"><b><?php echo $context['journal3_product_mpn_text']; ?>:</b> <span><?php echo $context['journal3_product_mpn_value']; ?></span></li>
        <?php } ?>
        <?php if ($context['journal3_product_location']) { ?>
          <li class="product-location"><b><?php echo $context['journal3_product_location_text']; ?>:</b> <span><?php echo $context['journal3_product_location_value']; ?></span></li>
        <?php } ?>
      </ul>
      <?php if ($context['journal3_product_manufacturer'] && $context['journal3_product_manufacturer_display'] == 'image') { ?>
        <div class="brand-image product-manufacturer">
          <a href="<?php echo $context['journal3_product_manufacturer_href']; ?>">
            <?php if ($context['journal3_product_manufacturer_image']) { ?>
              <img src="<?php echo $context['journal3_product_manufacturer_image']; ?>" <?php if (!empty($context['journal3_product_manufacturer_image2x'])) { ?>srcset="<?php echo $context['journal3_product_manufacturer_image']; ?> 1x, <?php echo $context['journal3_product_manufacturer_image2x']; ?> 2x"<?php } ?> alt="<?php echo $context['manufacturer']; ?>" width="<?php echo $context['journal3']->get('image_dimensions_manufacturer_logo.width'); ?>" height="<?php echo $context['journal3']->get('image_dimensions_manufacturer_logo.height'); ?>"/>
            <?php } ?>
            <span><?php echo $context['manufacturer']; ?></span>
          </a>
        </div>
      <?php } ?>
      <?php if ($context['journal3_product_sold'] || $context['journal3_product_views']) { ?>
        <div class="custom-stats">
          <?php if ($context['journal3_product_sold']) { ?>
            <div class="product-sold"><?php echo $context['journal3_product_sold']; ?></div>
          <?php } ?>
          <?php if ($context['journal3_product_views']) { ?>
            <div class="product-views"><?php echo $context['journal3_product_views']; ?></div>
          <?php } ?>
        </div>
      <?php } ?>
    </div>
    <?php
  }
} ?>
<?php echo $header; ?>
<?php if ($journal3->get('pageTitlePosition') == 'top') { ?>
  <h1 class="title page-title <?php echo $journal3->get("title_color_scheme"); ?>"><span class="page-title-text"><?php echo $heading_title; ?></span></h1>
<?php } ?>
<div class="breadcrumbs <?php echo $journal3->get("breadcrumbs_color_scheme"); ?>">
  <ul class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
      <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
    <?php } ?>
  </ul>
</div>
<?php echo $journal3_top; ?>
<div id="product-product" class="container">
  <div class="row"><?php echo $column_left; ?>
    <?php if ($column_left && $column_right) { ?>
    <?php $class = 'col-sm-6'; ?>
    <?php } elseif ($column_left || $column_right) { ?>
    <?php $class = 'col-sm-9'; ?>
    <?php } else { ?>
    <?php $class = 'col-sm-12'; ?>
    <?php } ?>
    <div id="content" class="<?php echo $class; ?>">
      <?php if ($journal3->get('pageTitlePosition') == 'default' || $journal3->is_quickview_popup) { ?>
      <h1 class="title page-title <?php echo $journal3->get("title_color_scheme"); ?>"><?php echo $heading_title; ?></h1>
      <?php } ?>
      <?php echo $content_top; ?>
      <?php echo $journal3_product_tabs_blocks_content_top; ?>
      <div class="product-info <?php echo $journal3->classes($journal3_product_classes); ?>">
        <?php if (!$journal3->is_options_popup) { ?>
        <div class="product-left">
          <div class="product-image direction-<?php echo $journal3_images_additional_direction; ?> position-<?php echo $journal3_images_additional_position; ?>">
            <div class="swiper main-image" data-options='<?php echo $journal3->jsonAttrs($journal3_images_carousel); ?>' <?php echo $journal3_images_style; ?>>
              <div class="swiper-container" <?php if ($journal3->is_rtl) { ?>dir="rtl"<?php } ?>>
                <div class="swiper-wrapper">
                  <?php foreach ($images as $index => $image) { ?>
                  <div class="swiper-slide" <?php if ($journal3_images_gallery) { ?>data-gallery=".lightgallery-product-images" data-index="<?php echo $index; ?>"<?php } ?>>
                    <?php if ($index && $journal3_image_placeholder) { ?>
                    <img class="lazyload" src="<?php echo $journal3_image_placeholder; ?>" data-src="<?php echo $image['thumb']; ?>" <?php if (!empty($image['thumb2x'])) { ?>data-srcset="<?php echo $image['thumb']; ?> 1x, <?php echo $image['thumb2x']; ?> 2x"<?php } ?> width="<?php echo $journal3_image_thumb_width; ?>" height="<?php echo $journal3_image_thumb_height; ?>" alt="<?php echo $heading_title; ?>" title="<?php echo $heading_title; ?>" data-largeimg="<?php echo $image['popup']; ?>"/>
                    <?php } else { ?>
                    <img src="<?php echo $image['thumb']; ?>" <?php if (!empty($image['thumb2x'])) { ?>srcset="<?php echo $image['thumb']; ?> 1x, <?php echo $image['thumb2x']; ?> 2x"<?php } ?> width="<?php echo $journal3_image_thumb_width; ?>" height="<?php echo $journal3_image_thumb_height; ?>" alt="<?php echo $heading_title; ?>" title="<?php echo $heading_title; ?>" data-largeimg="<?php echo $image['popup']; ?>"/>
                    <?php } ?>
                  </div>
                  <?php } ?>
                </div>
              </div>
              <div class="swiper-buttons">
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
              </div>
              <div class="swiper-pagination"></div>

              <?php if (!empty($journal3_product_labels['default'])) { ?>
              <div class="product-labels">
                <?php foreach ($journal3_product_labels['default'] as $id => $label) { ?>
                <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> product-label-<?php echo $label['positionDefault']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><?php echo $label['label']; ?></strong></span>
                <?php } ?>
              </div>
              <?php } ?>
            </div>
            <?php if ($journal3_images_additional) { ?>
            <?php if ($journal3_images_additional_carousel) { ?>
            <div class="swiper additional-images" data-options='<?php echo $journal3->jsonAttrs($journal3_images_additional_carousel_options); ?>' <?php echo $journal3_images_additional_style; ?>>
              <div class="swiper-container" <?php if ($journal3->is_rtl) { ?>dir="rtl"<?php } ?>>
                <div class="swiper-wrapper">
                  <?php foreach ($journal3_images_additional as $index => $image) { ?>
                  <div class="swiper-slide additional-image" data-index="<?php echo $index; ?>">
                    <img src="<?php echo $image['additional']; ?>" <?php if (!empty($image['additional2x'])) { ?>srcset="<?php echo $image['additional']; ?> 1x, <?php echo $image['additional2x']; ?> 2x"<?php } ?> width="<?php echo $journal3_image_additional_width; ?>" height="<?php echo $journal3_image_additional_height; ?>" alt="<?php echo $heading_title; ?>" title="<?php echo $heading_title; ?>"/>
                  </div>
                  <?php } ?>
                </div>
              </div>
              <div class="swiper-buttons">
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
              </div>
              <div class="swiper-pagination"></div>
            </div>
            <?php } else { ?>
            <div class="additional-images">
              <?php foreach ($journal3_images_additional as $index => $image) { ?>
              <div class="additional-image" data-index="<?php echo $index; ?>">
                <img src="<?php echo $image['additional']; ?>" <?php if (!empty($image['additional2x'])) { ?>srcset="<?php echo $image['additional']; ?> 1x, <?php echo $image['additional2x']; ?> 2x"<?php } ?> width="<?php echo $journal3_image_additional_width; ?>" height="<?php echo $journal3_image_additional_height; ?>" alt="<?php echo $heading_title; ?>" title="<?php echo $heading_title; ?>"/>
              </div>
              <?php } ?>
            </div>
            <?php } ?>
            <?php } ?>
          </div>

          <?php if ($journal3_images_gallery) { ?>
          <div class="lightgallery lightgallery-product-images" data-images='<?php echo htmlspecialchars(json_encode($journal3_images_gallery), ENT_QUOTES, 'UTF-8'); ?>' data-options='<?php echo $journal3->jsonAttrs($journal3_images_gallery_options); ?>'></div>
          <?php } ?>

          <?php echo $journal3_product_tabs_blocks_image; ?>

          <?php if ($description && $journal3->is_quickview_popup && ($journal3->get('quickviewDescription') && $journal3->get('quickviewDescriptionPosition') == 'image')) { ?>
          <div class="description expand-block <?php echo $quickviewExpand; ?>">
            <div class="expand-content"><?php echo $description; ?><?php if ($journal3->get('quickviewExpandButton')) { ?><div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div><?php } ?></div>
          </div>
          <?php } ?>

          <?php if (($tags && !$journal3->is_popup) && ($journal3->get($stylePrefix . 'TagsPosition') == 'image')) { ?>
          <div class="tags">
            <span class="tags-title"><?php echo $text_tags; ?></span>
            <?php for ($i = 0; $i < count($tags); $i++) { ?>
            <?php if ($i < (count($tags) - 1)) { ?>
            <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a><b>,</b>
            <?php } else { ?>
            <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a>
            <?php } ?>
            <?php } ?>
          </div>
          <?php } ?>
        </div>
        <?php } ?>
        <div class="product-right">
          <div class="product-right-wrapper">
          <div id="product" class="product-details">
            <?php if (!$journal3->is_options_popup) { ?>
            <div class="title page-title"><?php echo $heading_title; ?></div>
            <?php } ?>

            <?php echo $journal3_product_tabs_blocks_top; ?>

            <?php if ($description && $journal3->is_quickview_popup && ($journal3->get('quickviewDescription') && $journal3->get('quickviewDescriptionPosition') == 'top')) { ?>
            <div class="description expand-block <?php echo $quickviewExpand; ?>">
              <div class="expand-content"><?php echo $description; ?><?php if ($journal3->get('quickviewExpandButton')) { ?><div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div><?php } ?></div>
            </div>
            <?php } ?>

            <?php if (!empty($journal3_product_labels['group_outside'])) { ?>
            <div class="product-labels">
              <?php foreach ($journal3_product_labels['group_outside'] as $id => $label) { ?>
              <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> product-label-<?php echo $label['positionDefault']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><a class="label-link" <?php if ($label['link']['href']): ?>href="<?php echo $label['link']['href']; ?>"<?php endif; ?> <?php echo $journal3->linkAttrs($label['link']); ?> aria-hidden="true" tabindex="-1"><?php echo $label['label']; ?></a></strong></span>
              <?php } ?>
            </div>
            <?php } ?>

            <?php if ($journal3_product_stats_position == 'default') { ?>
            <?php productStats(get_defined_vars()); ?>
            <?php } ?>

            <?php if ($review_status && !$journal3->is_popup) { ?>
            <div class="rating">
              <div class="rating-stars">
                <?php for ($i = 1; $i <= 5; $i++) { ?>
                <?php if ($rating < $i) { ?>
                <span class="fa fa-stack"><em class="fa fa-star-o fa-stack-1x"></em></span>
                <?php } else { ?>
                <span class="fa fa-stack"><em class="fa fa-star fa-stack-1x"></em><em class="fa fa-star-o fa-stack-1x"></em></span>
                <?php } ?>
                <?php } ?>
              </div>
              <div class="review-links">
                <a role="button"><?php echo $reviews; ?></a>
                <b><?php echo $journal3->get($stylePrefix . 'RatingSeparator'); ?></b>
                <a role="button"><?php echo $text_write; ?></a>
              </div>
            </div>
            <?php } ?>

            <?php if ($journal3_product_countdown) { ?>
            <div class="countdown-wrapper">
              <?php if ($journal3->get($stylePrefix . 'CountdownText')) { ?>
              <h5 class="countdown-title title"><?php echo $journal3->get($stylePrefix . 'CountdownText'); ?></h5>
              <?php } ?>
              <div class="countdown" data-date="<?php echo $journal3_product_countdown; ?>">
                <div><em class="fa fa-spinner fa-spin"></em><span><?php echo $journal3->get('countdownDay'); ?></span></div>
                <div><em class="fa fa-spinner fa-spin"></em><span><?php echo $journal3->get('countdownHour'); ?></span></div>
                <div><em class="fa fa-spinner fa-spin"></em><span><?php echo $journal3->get('countdownMin'); ?></span></div>
                <div><em class="fa fa-spinner fa-spin"></em><span><?php echo $journal3->get('countdownSec'); ?></span></div>
              </div>
            </div>
            <?php } ?>

            <?php if ($price && !$journal3->is_options_popup) { ?>
            <div class="product-price-group">
              <div class="price-wrapper">
                <?php if (!empty($journal3_product_labels['price'])) { ?>
                  <div class="product-labels-price">
                    <?php foreach ($journal3_product_labels['price'] as $id => $label) { ?>
                      <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> product-label-<?php echo $label['positionDefault']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><?php echo $label['label']; ?></strong></span>
                    <?php } ?>
                  </div>
                <?php } ?>
                <div class="price-group">
                  <?php if (!$special) { ?>
                  <div class="product-price"><?php echo $price; ?></div>
                  <?php } else { ?>
                  <div class="product-price-old"><?php echo $price; ?></div>
                  <div class="product-price-new"><?php echo $special; ?></div>
                  <?php } ?>
                </div>
                <?php if ($tax) { ?>
                <div class="product-tax"><?php echo $text_tax; ?> <?php echo $tax; ?></div>
                <?php } ?>
                <?php if ($points) { ?>
                <div class="product-points"><?php echo $text_points; ?> <?php echo $points; ?></div>
                <?php } ?>
                <?php if ($discounts) { ?>
                <div class="discounts">
                  <?php foreach ($discounts as $discount) { ?>
                  <div class="product-discount"><?php echo $discount['quantity']; ?><?php echo $text_discount; ?><?php echo $discount['price']; ?></div>
                  <?php } ?>
                </div>
                <?php } ?>
              </div>
              <?php if ($journal3_product_stats_position == 'price') { ?>
              <?php productStats(get_defined_vars()); ?>
              <?php } ?>
            </div>
            <?php } ?>

            <?php if ($options) { ?>
            <div class="product-options">
            <h3 class="options-title title"><?php echo $text_option; ?></h3>
            <?php foreach ($options as $option) { ?>
            <?php if ($option['type'] == 'select') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?> <?php if ($journal3->get($stylePrefix . 'OptionsPushSelect')) { ?>push-option<?php } ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <select name="option[<?php echo $option['product_option_id']; ?>]" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control">
                <option value=""><?php echo $text_select; ?></option>
                <?php foreach ($option['product_option_value'] as $option_value) { ?>
                <option value="<?php echo $option_value['product_option_value_id']; ?>"><?php echo $option_value['name']; ?>
                <?php if ($option_value['price'] && $optionPrice) { ?>
                (<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)
                <?php } ?> </option>
                <?php } ?>
              </select>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'radio') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?> <?php if ($journal3->get($stylePrefix . 'OptionsPushRadio')) { ?>push-option<?php } ?>">
              <label class="control-label"><?php echo $option['name']; ?></label>
              <div id="input-option<?php echo $option['product_option_id']; ?>"> <?php foreach ($option['product_option_value'] as $option_value) { ?>
                <div class="radio">
                  <label>
                    <input type="radio" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option_value['product_option_value_id']; ?>" title="<?php echo $option_value['name']; ?>" aria-label="<?php echo $option_value['name']; ?>" />
                    <span class="option-wrapper <?php if ($option_value['image']) { ?>push-option-image<?php } ?>">
                    <?php if ($option_value['image']) { ?>
                      <img src="<?php echo $option_value['image']; ?>" srcset="<?php echo $option_value['image']; ?> 1x, <?php echo $option_value['image2x']; ?> 2x" width="<?php echo $journal3_image_options_width; ?>" height="<?php echo $journal3_image_options_height; ?>" alt="<?php echo $option_value['name']; ?> <?php if ($option_value['price'] && $optionPrice) { ?> <?php echo $option_value['price_prefix']; ?> <?php echo $option_value['price']; ?> <?php } ?>" <?php if ($journal3->is_desktop) { ?>data-toggle="tooltip-hover" data-tooltip-class="push-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'PushTooltipPosition'); ?>"<?php } ?> title="<?php echo $option_value['name']; ?> <?php if ($option_value['price'] && $optionPrice) { ?> (<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>) <?php } ?>"/>
                    <?php } ?>
                    <span class="option-value">
                      <?php echo $option_value['name']; ?>
                      <?php if ($option_value['price'] && $optionPrice) { ?>
                        <span class="option-price">
                          (<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)
                        </span>
                      <?php } ?>
                    </span>
                    </span>
                  </label>
                </div>
                <?php } ?> </div>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'checkbox') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?> <?php if ($journal3->get($stylePrefix . 'OptionsPushCheckbox')) { ?>push-option<?php } ?>">
              <label class="control-label"><?php echo $option['name']; ?></label>
              <div id="input-option<?php echo $option['product_option_id']; ?>"> <?php foreach ($option['product_option_value'] as $option_value) { ?>
                <div class="checkbox">
                  <label>
                    <input type="checkbox" name="option[<?php echo $option['product_option_id']; ?>][]" value="<?php echo $option_value['product_option_value_id']; ?>" title="<?php echo $option_value['name']; ?>" aria-label="<?php echo $option_value['name']; ?>" />
                    <span class="option-wrapper <?php if ($option_value['image']) { ?>push-option-image<?php } ?>">
                    <?php if ($option_value['image']) { ?>
                      <img src="<?php echo $option_value['image']; ?>" srcset="<?php echo $option_value['image']; ?> 1x, <?php echo $option_value['image2x']; ?> 2x" width="<?php echo $journal3_image_options_width; ?>" height="<?php echo $journal3_image_options_height; ?>" alt="<?php echo $option_value['name']; ?> <?php if ($option_value['price'] && $optionPrice) { ?> <?php echo $option_value['price_prefix']; ?> <?php echo $option_value['price']; ?> <?php } ?>" <?php if ($journal3->is_desktop) { ?>data-toggle="tooltip-hover" data-tooltip-class="push-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'PushTooltipPosition'); ?>"<?php } ?> title="<?php echo $option_value['name']; ?> <?php if ($option_value['price'] && $optionPrice) { ?> (<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>) <?php } ?>">
                    <?php } ?>
                    <span class="option-value">
                      <?php echo $option_value['name']; ?>
                      <?php if ($option_value['price'] && $optionPrice) { ?>
                        <span class="option-price">(<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)</span>
                      <?php } ?>
                    </span>
                    </span>
                  </label>
                </div>
                <?php } ?> </div>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'text') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" placeholder="<?php echo $option['name']; ?>" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'textarea') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <textarea name="option[<?php echo $option['product_option_id']; ?>]" rows="5" placeholder="<?php echo $option['name']; ?>" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control"><?php echo $option['value']; ?></textarea>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'file') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label"><?php echo $option['name']; ?></label>
              <button type="button" id="button-upload<?php echo $option['product_option_id']; ?>" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-default btn-block upload-btn"><i class="fa fa-upload"></i> <?php echo $button_upload; ?></button>
              <input type="hidden" name="option[<?php echo $option['product_option_id']; ?>]" value="" id="input-option<?php echo $option['product_option_id']; ?>" >
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'date') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <div class="input-group date" data-picker-class="product-options pp-date-time-picker">
                <input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="YYYY-MM-DD" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
                <span class="input-group-btn">
                <button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
                </span></div>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'datetime') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <div class="input-group datetime" data-picker-class="product-options pp-date-time-picker">
                <input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
                <span class="input-group-btn">
                <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                </span></div>
            </div>
            <?php } ?>
            <?php if ($option['type'] == 'time') { ?>
            <div class="form-group<?php if ($option['required']) { ?> required <?php } ?> product-option-<?php echo $option['type']; ?>">
              <label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
              <div class="input-group time" data-picker-class="product-options pp-date-time-picker">
                <input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="HH:mm" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
                <span class="input-group-btn">
                <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                </span></div>
            </div>
            <?php } ?>
            <?php } ?>
            </div>
            <?php } ?>

            <?php if ($recurrings) { ?>
            <h3><?php echo $text_payment_recurring; ?></h3>
            <div class="form-group required">
              <select name="recurring_id" class="form-control">
                <option value=""><?php echo $text_select; ?></option>
                <?php foreach ($recurrings as $recurring) { ?>
                <option value="<?php echo $recurring['recurring_id']; ?>"><?php echo $recurring['name']; ?></option>
                <?php } ?>
              </select>
              <div class="help-block" id="recurring-description"></div>
            </div>
            <?php } ?>

            <?php if ($journal3->get('catalogCartStatus') || $journal3->get('catalogWishlistStatus') || $journal3->get('catalogCompareStatus') || ($journal3_product_extra_buttons && !$journal3->is_popup)) { ?>
            <div class="button-group-page">
              <div class="buttons-wrapper">
                <div class="stepper-group cart-group">
                  <?php if ($journal3->get('catalogCartStatus')) { ?>
                    <div class="stepper">
                      <label class="control-label" for="product-quantity"><?php echo $entry_qty; ?></label>
                      <button aria-label="-" class="fa fa-angle-down"></button>
                      <input id="product-quantity" type="text" name="quantity" value="<?php echo $journal3_product_quantity > 0 ? $journal3_product_quantity : $minimum; ?>" data-minimum="<?php echo $minimum; ?>" class="form-control"/>
                      <input id="product-id" type="hidden" name="product_id" value="<?php echo $product_id; ?>" />
                      <button aria-label="+" class="fa fa-angle-up"></button>
                    </div>
                  <a id="button-cart" role="button" aria-label="<?php echo $journal3_button_cart; ?>" data-loading-text="<span class='btn-text'><?php echo $journal3_button_cart; ?></span>" class="btn btn-cart" <?php if ($journal3->is_desktop && ($journal3->get($stylePrefix . 'CartDisplay') == "icon") && ($journal3->get($stylePrefix . 'CartTooltipStatus'))) { ?> data-toggle="tooltip-hover" data-tooltip-class="pp-cart-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'CartTooltipPosition'); ?>" title="<?php echo $journal3_button_cart; ?>" <?php } ?>><span class="btn-text"><?php echo $journal3_button_cart; ?></span></a>
                  <?php } ?>
                  <?php if ($journal3_product_extra_buttons && !$journal3->is_popup) { ?>
                  <div class="extra-group">
                    <?php $index = 0; foreach ($journal3_product_extra_buttons as $id => $extra_button) { $index++; ?>
                    <a class="btn btn-extra btn-extra-<?php echo $id; ?> btn-<?php echo $index; ?>-extra" <?php if ($journal3->is_desktop && ($journal3->get($stylePrefix . 'Extra' . $index . 'ButtonDisplay') == "icon" && $journal3->get($stylePrefix . 'ExtraTooltipStatus'))) { ?> data-toggle="tooltip-hover" data-tooltip-class="extra-tooltip pp-extra-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'ExtraTooltipPosition'); ?>" title="<?php echo $extra_button['label']; ?>"<?php } ?> <?php if( $extra_button['action'] == 'quickbuy') { ?>data-quick-buy<?php } ?> <?php if( $extra_button['action'] == 'link' && $extra_button['link']['href']) { ?>href="<?php echo $extra_button['link']['href']; ?>" <?php echo $journal3->linkAttrs($extra_button['link']); ?> data-product_id="<?php echo $product_id; ?>" <?php } else {?>role="button" <?php } ?> data-loading-text="<span class='btn-text'><?php echo $extra_button['label']; ?></span>"><span class="btn-text"><?php echo $extra_button['label']; ?></span></a>
                    <?php } ?>
                  </div>
                  <?php } ?>
                </div>
                <?php if ($journal3->get('catalogWishlistStatus') || $journal3->get('catalogCompareStatus') || $journal3->is_quickview_popup) { ?>
                <div class="wishlist-compare">
                  <?php if (!$journal3->is_options_popup) { ?>
                    <?php if ($journal3->get('catalogWishlistStatus')) { ?>
                    <a class="btn btn-wishlist" role="button" aria-label="<?php echo $button_wishlist; ?>" <?php if ($journal3->is_desktop && ($journal3->get($stylePrefix . 'WishlistDisplay') == "icon") && ($journal3->get($stylePrefix . 'WishlistTooltipStatus'))) { ?> data-toggle="tooltip-hover" data-tooltip-class="pp-wishlist-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'WishlistTooltipPosition'); ?>" title="<?php echo $button_wishlist; ?>" <?php } ?> onclick="parent.wishlist.add(<?php echo $product_id; ?>);"><span class="btn-text"><?php echo $button_wishlist; ?></span></a>
                    <?php } ?>
                    <?php if ($journal3->get('catalogCompareStatus')) { ?>
                    <a class="btn btn-compare" role="button" aria-label="<?php echo $button_compare; ?>" <?php if ($journal3->is_desktop && ($journal3->get($stylePrefix . 'CompareDisplay') == "icon") && ($journal3->get($stylePrefix . 'CompareTooltipStatus'))) { ?> data-toggle="tooltip-hover" data-tooltip-class="pp-compare-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'CompareTooltipPosition'); ?>" title="<?php echo $button_compare; ?>" <?php } ?> onclick="parent.compare.add(<?php echo $product_id; ?>);"><span class="btn-text"><?php echo $button_compare; ?></span></a>
                    <?php } ?>
                  <?php } ?>
                </div>
                  <?php if ($journal3->is_quickview_popup) { ?>
                  <a class="btn btn-more-details" href="<?php echo $journal3_view_more_url; ?>" target="_top" <?php if ($journal3->is_desktop && ($journal3->get($stylePrefix . 'MoreDetailsDisplay') == "icon") && ($journal3->get($stylePrefix . 'MoreDetailsTooltipStatus'))) { ?> data-toggle="tooltip-hover" data-tooltip-class="more-details-tooltip" data-placement="<?php echo $journal3->get($stylePrefix . 'MoreDetailsTooltipPosition'); ?>" title="<?php echo $journal3->get('quickviewExtraText'); ?>" <?php } ?>><span class="btn-text"><?php echo $journal3->get('quickviewExtraText'); ?></span></a>
                  <?php } ?>
                <?php } ?>
              </div>
            </div>
            <?php } ?>

            <?php if ($minimum > 1) { ?>
            <div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo $text_minimum; ?></div>
            <?php } ?>

            <?php echo $journal3_product_tabs_blocks_details; ?>
          </div>

          <?php echo $journal3_product_tabs_blocks_bottom; ?>

          <?php if (($tags && !$journal3->is_popup) && ($journal3->get($stylePrefix . 'TagsPosition') == 'details')) { ?>
          <div class="tags">
            <span class="tags-title"><?php echo $text_tags; ?></span>
            <?php for ($i = 0; $i < count($tags); $i++) { ?>
            <?php if ($i < (count($tags) - 1)) { ?>
            <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a><b>,</b>
            <?php } else { ?>
            <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a>
            <?php } ?>
            <?php } ?>
          </div>
          <?php } ?>
          </div>
          <?php if (!$journal3->is_popup && ($journal3->get($stylePrefix . 'PricePosition') || $journal3->get($stylePrefix . 'ButtonsPosition'))) { ?>
          <div class="product-side-position"></div>
          <script>
            (function () {
              const $psp = document.querySelector('.product-side-position');
              <?php if ($journal3->get($stylePrefix . 'PricePosition')) { ?>
              $psp.appendChild(document.querySelector('.product-price-group'));
              <?php } ?>
              <?php if ($journal3->get($stylePrefix . 'ButtonsPosition')) { ?>
              $psp.appendChild(document.querySelector('.button-group-page'));
              <?php } ?>
            })();
          </script>
          <?php } ?>
        </div>
      </div>

      <?php if ($description && $journal3->is_quickview_popup && $journal3->get('quickviewDescription') && ($journal3->get('quickviewDescriptionPosition') == 'default')) { ?>
        <div class="description expand-block <?php echo $quickviewExpand; ?>">
          <div class="expand-content"><?php echo $description; ?><?php if ($journal3->get('quickviewExpandButton')) { ?><div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div><?php } ?></div>
        </div>
      <?php } ?>

      <?php echo $journal3_product_tabs_blocks_default; ?>

      <?php if (($tags && !$journal3->is_popup) && ($journal3->get($stylePrefix . 'TagsPosition') == 'default')) { ?>
        <div class="tags">
        <span class="tags-title"><?php echo $text_tags; ?></span>
        <?php for ($i = 0; $i < count($tags); $i++) { ?>
        <?php if ($i < (count($tags) - 1)) { ?>
        <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a><b>,</b>
        <?php } else { ?>
        <a href="<?php echo $tags[$i]['href']; ?>"><?php echo $tags[$i]['tag']; ?></a>
        <?php } ?>
        <?php } ?>
        </div>
      <?php } ?>
      <?php echo $content_bottom; ?></div>
    <?php echo $column_right; ?></div>
</div>
<script>
  // calculate vertical images height
  (function () {
    const $img = document.querySelector('.direction-vertical .main-image .swiper-slide img');
    const $ad = document.querySelector('.direction-vertical .additional-images');

    if ($img && $ad) {
      $ad.style.height = $img.offsetHeight + 'px';
    }
  })();
</script>
<script type="text/javascript"><!--
$('select[name=\'recurring_id\'], input[name="quantity"]').change(function(){
	$.ajax({
		url: 'index.php?route=product/product/getRecurringDescription',
		type: 'post',
		data: $('input[name=\'product_id\'], input[name=\'quantity\'], select[name=\'recurring_id\']'),
		dataType: 'json',
		beforeSend: function() {
			$('#recurring-description').html('');
		},
		success: function(json) {
			$('.alert, .text-danger').remove();

			if (json['success']) {
				$('#recurring-description').html(json['success']);
			}
		}
	});
});
//--></script>
<script type="text/javascript"><!--
$('#button-cart, [data-quick-buy]').on('click', function () {
  var $btn = $(this);
	$.ajax({
		url: 'index.php?route=checkout/cart/add',
		type: 'post',
    data: $(
      '#product .button-group-page input[type=\'text\'], #product .button-group-page input[type=\'hidden\'], #product .button-group-page input[type=\'radio\']:checked, #product .button-group-page input[type=\'checkbox\']:checked, #product .button-group-page select, #product .button-group-page textarea, ' +
      '#product .product-options input[type=\'text\'], #product .product-options input[type=\'hidden\'], #product .product-options input[type=\'radio\']:checked, #product .product-options input[type=\'checkbox\']:checked, #product .product-options select, #product .product-options textarea, ' +
      '#product select[name="recurring_id"]'
    ),
		dataType: 'json',
		beforeSend: function() {
			$('#button-cart').button('loading');
		},
		complete: function() {
			$('#button-cart').button('reset');
		},
		success: function(json) {
			$('.alert, .text-danger').remove();
			$('.form-group').removeClass('has-error');

			if (json['error']) {
				if (json['error']['option']) {
					for (i in json['error']['option']) {
						var element = $('#input-option' + i.replace('_', '-'));

						if (element.parent().hasClass('input-group')) {
							element.parent().after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
						} else {
							element.after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
						}
					}
				}

				if (json['error']['recurring']) {
					$('select[name=\'recurring_id\']').after('<div class="text-danger">' + json['error']['recurring'] + '</div>');
				}

				// Highlight any found errors
				$('.text-danger').parent().addClass('has-error');

        try {
          $('html, body').animate({ scrollTop: $('.form-group.has-error').offset().top - $('header').height() - 20 }, 'slow');
        } catch (e) {
        }
			}

      if (json['success']) {
        if ($('html').hasClass('popup-options')) {
          parent.$(".popup-options .popup-close").trigger('click');
        }

        if (json['notification']) {
          parent.show_notification(json['notification']);
        } else {
          parent.$('#content').parent().before('<div class="alert alert-success alert-dismissible"><i class="fa fa-check-circle"></i> ' + json['success'] + ' <button type="button" class="close" data-dismiss="alert">&times;</button></div>');
        }

        parent.$('#cart-total').html(json['total']);
        parent.$('#cart-items,.cart-badge').html(json['items_count']);

        if (json['items_count']) {
          parent.$('#cart-items,.cart-badge').removeClass('count-zero');
          parent.$('#cart').addClass('cart-has-items');
        } else {
          parent.$('#cart-items,.cart-badge').addClass('count-zero');
          parent.$('#cart').removeClass('cart-has-items');
        }

        if (Journal['scrollToTop']) {
          parent.$('html, body').animate({ scrollTop: 0 }, 'slow');
        }

        parent.$('.cart-content ul').load('index.php?route=common/cart/info ul li');

        if (window.location.href.indexOf('quick_buy=true') !== -1) {
          parent.location.href = Journal['checkoutUrl'];
        }

        if ($btn.data('quick-buy') !== undefined) {
          location = Journal['checkoutUrl'];
        }

        if (parent.window['_QuickCheckout']) {
          parent.window['_QuickCheckout'].save();
        }

        if (json['redirect']) {
          parent.location.href = json['redirect'];
        }
      }
		},
        error: function(xhr, ajaxOptions, thrownError) {
            alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
	});
});
//--></script>
<script type="text/javascript"><!--
$('.date').datetimepicker({
	pickTime: false
});

$('.datetime').datetimepicker({
	pickDate: true,
	pickTime: true
});

$('.time').datetimepicker({
	pickDate: false
});

$('button[id^=\'button-upload\']').on('click', function() {
	var node = this;

	$('#form-upload').remove();

	$('body').prepend('<form enctype="multipart/form-data" id="form-upload" style="display: none;"><input type="file" name="file" /></form>');

	$('#form-upload input[name=\'file\']').trigger('click');

	if (typeof timer != 'undefined') {
    	clearInterval(timer);
	}

	timer = setInterval(function() {
		if ($('#form-upload input[name=\'file\']').val() != '') {
			clearInterval(timer);

			$.ajax({
				url: 'index.php?route=tool/upload',
				type: 'post',
				dataType: 'json',
				data: new FormData($('#form-upload')[0]),
				cache: false,
				contentType: false,
				processData: false,
				beforeSend: function() {
					$(node).button('loading');
				},
				complete: function() {
					$(node).button('reset');
				},
				success: function(json) {
					$('.text-danger').remove();

					if (json['error']) {
						$(node).parent().find('input').after('<div class="text-danger">' + json['error'] + '</div>');
					}

					if (json['success']) {
						alert(json['success']);

						$(node).parent().find('input').val(json['code']);
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				}
			});
		}
	}, 500);
});
//--></script>
<script type="text/javascript"><!--
$(function () {
  $('#review').delegate('.pagination a', 'click', function(e) {
    e.preventDefault();

    $('#review').fadeOut('slow');

    $('#review').load(this.href);

    $('#review').fadeIn('slow');
  });

  $('#review').load('index.php?route=product/product/review&product_id=<?php echo $product_id; ?>');

  $('#button-review').on('click', function() {
    $.ajax({
      url: 'index.php?route=product/product/write&product_id=<?php echo $product_id; ?>',
      type: 'post',
      dataType: 'json',
      data: $("#form-review").serialize(),
      beforeSend: function() {
        $('#button-review').button('loading');
      },
      complete: function() {
        $('#button-review').button('reset');
      },
      success: function(json) {
        $('.alert-success, .alert-danger').remove();

        if (json['error']) {
          $('#review').after('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
        }

        if (json['success']) {
          $('#review').after('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

          $('input[name=\'name\']').val('');
          $('textarea[name=\'text\']').val('');
          $('input[name=\'rating\']:checked').prop('checked', false);
        }
      }
    });
  });
});

$(document).ready(function() {
	$('.thumbnails').magnificPopup({
		type:'image',
		delegate: 'a',
		gallery: {
			enabled:true
		}
	});
});

$(document).ready(function () {
  $('.review-links a').on('click', function () {
    var $review = $('#review');
    if ($review.length) {
      $('a[href="#' + $review.closest('.module-item').attr('id') + '"]').trigger('click');
      $('a[href="#' + $review.closest('.tab-pane').attr('id') + '"]').trigger('click');
      $('a[href="#' + $review.closest('.panel-collapse').attr('id') + '"]').trigger('click');
      $review.closest('.expand-block').find('.block-expand.btn').trigger('click');

      $([document.documentElement, document.body]).animate({
        scrollTop: $review.offset().top - $('header').height() - 20
      }, 200);
    }
  });

  $('#read-more-desc').on('click', function () {
    var $desc = $('.product-extra-description');
    if ($desc.length) {
      $('a[href="#' + $desc.closest('.module-item').attr('id') + '"]').trigger('click');
      $('a[href="#' + $desc.closest('.tab-pane').attr('id') + '"]').trigger('click');
      $('a[href="#' + $desc.closest('.panel-collapse').attr('id') + '"]').trigger('click');
      $desc.find('.expand-block').find('.block-expand.btn').trigger('click');

      $([document.documentElement, document.body]).animate({
        scrollTop: $desc.offset().top - $('header').height() - 20
      }, 200);
    }
  });
});
//--></script>
<?php echo $journal3_rich_snippets; ?>
<?php echo $footer; ?>
