<?php $context = get_defined_vars(); ?>
<?php foreach ($products as $product): ?>
  <div class="product-layout <?php echo $journal3->classes($product['classes']); ?>">
    <div class="side-product">
      <div class="image">
        <a href="<?php echo $product['href']; ?>" class="product-img" title="<?php echo $product['name']; ?>">
          <?php if ($journal3->get('performanceLazyLoadImagesStatus')): ?>
            <img src="<?php echo $dummy_image; ?>" data-src="<?php echo $product['thumb']; ?>" <?php if ($product['thumb2x']): ?>data-srcset="<?php echo $product['thumb']; ?> 1x, <?php echo $product['thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-first lazyload"/>
          <?php else: ?>
            <img src="<?php echo $product['thumb']; ?>" <?php if ($product['thumb2x']): ?>srcset="<?php echo $product['thumb']; ?> 1x, <?php echo $product['thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-first"/>
          <?php endif; ?>
        </a>

        <?php if ($journal3->get('quickviewStatus')): ?>
          <div class="quickview-button">
            <a class="btn btn-quickview" role="button" aria-label="<?php echo $journal3->get('quickviewText'); ?>" <?php if ($journal3->is_desktop && $journal3->getIn('SideProductQuickviewTooltipStatus', $context)): ?>data-toggle="tooltip-hover" data-tooltip-class="<?php echo 'module-side_products-' . $module_id; ?> quickview-tooltip" data-placement="<?php echo $journal3->getIn('SideProductQuickviewTooltipPosition', $context); ?>" title="<?php echo $journal3->get('quickviewText'); ?>"<?php endif; ?> onclick="quickview('<?php echo $product['product_id']; ?>')"><span class="btn-text"><?php echo $journal3->get('quickviewText'); ?></span></a>
          </div>
        <?php endif; ?>
      </div>

      <div class="caption">
        <div class="name"><a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?></a></div>

        <?php if ($product['price']): ?>
          <div class="price">
            <?php if ($product['special']): ?>
              <span class="price-new"><?php echo $product['special']; ?></span> <span class="price-old"><?php echo $product['price']; ?></span>
            <?php else: ?>
              <span class="price-normal"><?php echo $product['price']; ?></span>
            <?php endif; ?>
          </div>
          <?php if ($product['tax']): ?>
            <div class="price-tax"><?php echo $text_tax; ?><?php echo $product['tax']; ?></div>
          <?php endif; ?>
        <?php endif; ?>

        <?php if ($product['rating']): ?>
          <div class="rating <?php if ($journal3->getIn('SideProductRatingPosition', $context) == "hover"): ?>rating-hover<?php endif; ?>">
            <div class="rating-stars">
              <?php for ($i = 1; $i <= 5; $i++): ?>
                <?php if ($product['rating'] < $i): ?>
                  <span class="fa fa-stack"><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php else: ?>
                  <span class="fa fa-stack"><em class="fa fa-star fa-stack-2x"></em><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php endif; ?>
              <?php endfor; ?>
            </div>
          </div>
        <?php else: ?>
          <div class="rating no-rating <?php if ($journal3->getIn('SideProductRatingPosition', $context) == "hover"): ?>rating-hover<?php endif; ?>">
            <div class="rating-stars">
              <?php for ($i = 1; $i <= 5; $i++): ?>
                <?php if ($product['rating'] < $i): ?>
                  <span class="fa fa-stack"><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php else: ?>
                  <span class="fa fa-stack"><em class="fa fa-star fa-stack-2x"></em><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php endif; ?>
              <?php endfor; ?>
            </div>
          </div>
        <?php endif; ?>

        <?php if ($journal3->get('catalogCartStatus') || $journal3->get('catalogWishlistStatus') || $journal3->get('catalogCompareStatus')): ?>
          <div class="button-group">
            <?php if ($journal3->get('catalogCartStatus')): ?>
              <a class="btn btn-cart" role="button" aria-label="<?php echo $product['button_cart']; ?>" <?php if ($journal3->is_desktop && $journal3->getIn('SideProductCartTooltipStatus', $context)): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo 'module-side_products-' . $module_id; ?> cart-tooltip" data-placement="<?php echo $journal3->getIn('SideProductCartTooltipPosition', $context); ?>" title="<?php echo $product['button_cart']; ?>" <?php endif; ?> onclick="cart.add('<?php echo $product['product_id']; ?>//', $(this).closest('.product-thumb').find('.button-group input[name=\'quantity\']').val());" data-loading-text="<span class='btn-text'><?php echo $product['button_cart']; ?></span>"><span class="btn-text"><?php echo $product['button_cart']; ?></span></a>
            <?php endif; ?>
            <?php if ($journal3->get('catalogWishlistStatus')): ?>
              <a class="btn btn-wishlist" role="button" aria-label="<?php echo $button_wishlist; ?>" <?php if ($journal3->is_desktop && $journal3->getIn('SideProductWishlistTooltipStatus', $context)): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo 'module-side_products-' . $module_id; ?> wishlist-tooltip" data-placement="<?php echo $journal3->getIn('SideProductWishlistTooltipPosition', $context); ?>" title="<?php echo $button_wishlist; ?>" <?php endif; ?> onclick="wishlist.add('<?php echo $product['product_id']; ?>//')"><span class="btn-text"><?php echo $button_wishlist; ?></span></a>
            <?php endif; ?>
            <?php if ($journal3->get('catalogCompareStatus')): ?>
              <a class="btn btn-compare" role="button" aria-label="<?php echo $button_compare; ?>" <?php if ($journal3->is_desktop && $journal3->getIn('SideProductCompareTooltipStatus', $context)): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo 'module-side_products-' . $module_id; ?> compare-tooltip" data-placement="<?php echo $journal3->getIn('SideProductCompareTooltipPosition', $context); ?>" title="<?php echo $button_compare; ?>" <?php endif; ?> onclick="compare.add('<?php echo $product['product_id']; ?>//')"><span class="btn-text"><?php echo $button_compare; ?></span></a>
            <?php endif; ?>
          </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
<?php endforeach; ?>
