<?php $context = get_defined_vars(); ?>
<?php $prefix = $display === 'grid' ? 'ProductGrid' : 'ProductList'; ?>
  <div class="product-layout <?php echo $journal3->classes(\Journal3\Utils\Arr::get($product, 'classes')); ?>" data-product-id="<?php echo $product['product_id']; ?>">
    <div class="product-thumb">
      <?php if ($journal3->getIn($prefix . 'NamePosition', $context) == "image"): ?>
      <div class="name"><a href="<?php echo $product['href']; ?>" title="<?php echo $product['name']; ?>"><?php echo $product['name']; ?></a></div>
      <?php endif; ?>
      <div class="image-group">
        <div class="image">
          <?php if ($journal3->get('quickviewStatus')): ?>
            <div class="quickview-button">
              <a class="btn btn-quickview" role="button" aria-label="<?php echo $journal3->get('quickviewText'); ?>" <?php if ( $journal3->is_desktop && $journal3->getIn($prefix . 'QuickviewDisplay', $context) == 'icon' && $journal3->getIn($prefix . 'QuickviewTooltipStatus', $context)): ?>data-toggle="tooltip-hover" data-tooltip-class="<?php echo isset($module_id) ? 'module-products-' . $module_id . ' module-products-grid' : 'product-grid'; ?> quickview-tooltip" data-placement="<?php echo $journal3->getIn($prefix . 'QuickviewTooltipPosition', $context); ?>" title="<?php echo $journal3->get('quickviewText'); ?>"<?php endif; ?> onclick="quickview('<?php echo $product['product_id']; ?>')"><span class="btn-text"><?php echo $journal3->get('quickviewText'); ?></span></a>
            </div>
          <?php endif; ?>

          <a href="<?php echo $product['href']; ?>" class="product-img <?php if ($product['second_thumb']): ?>has-second-image<?php endif; ?>" title="<?php echo $product['name']; ?>">
            <div>
              <?php if ($journal3->get('performanceLazyLoadImagesStatus')): ?>
                <img src="<?php echo $dummy_image; ?>" data-src="<?php echo $product['thumb']; ?>" <?php if ($product['thumb2x']): ?>data-srcset="<?php echo $product['thumb']; ?> 1x, <?php echo $product['thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive img-first lazyload"/>
              <?php else: ?>
                <img src="<?php echo $product['thumb']; ?>" <?php if ($product['thumb2x']): ?>srcset="<?php echo $product['thumb']; ?> 1x, <?php echo $product['thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive img-first"/>
              <?php endif; ?>

              <?php if ($product['second_thumb']): ?>
                <?php if ($journal3->get('performanceLazyLoadImagesStatus')): ?>
                  <img src="<?php echo $dummy_image; ?>" data-src="<?php echo $product['second_thumb']; ?>" <?php if ($product['second_thumb2x']): ?>data-srcset="<?php echo $product['second_thumb']; ?> 1x, <?php echo $product['second_thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive img-second lazyload"/>
                <?php else: ?>
                  <img data-src="<?php echo $product['second_thumb']; ?>" <?php if ($product['second_thumb2x']): ?>srcset="<?php echo $product['second_thumb']; ?> 1x, <?php echo $product['second_thumb2x']; ?> 2x" <?php endif; ?> width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive img-second"/>
                <?php endif; ?>
              <?php endif; ?>
            </div>
          </a>

          <?php if (!empty($product['labels']['default'])): ?>
            <div class="product-labels">
              <?php foreach ($product['labels']['default'] as $id => $label): ?>
                <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> product-label-<?php echo $label['positionDefault']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><?php echo $label['label']; ?></strong></span>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>

          <?php if ($journal3->get('countdownStatus') && $product['date_end']): ?>
            <div class="countdown" data-date="<?php echo $product['date_end']; ?>"></div>
          <?php endif; ?>

          <?php if (!empty($product['labels']['group_outside'])): ?>
            <div class="product-labels">
              <?php foreach ($product['labels']['group_outside'] as $id => $label): ?>
                  <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> product-label-<?php echo $label['positionDefault']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><a class="label-link" <?php if ($label['link']['href']): ?>href="<?php echo $label['link']['href']; ?>"<?php endif; ?> <?php echo $journal3->linkAttrs($label['link']); ?> aria-hidden="true" tabindex="-1"><?php echo $label['label']; ?></a></strong></span>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <div class="caption">

        <?php if ($product['stat1'] || $product['stat2']): ?>
          <div class="stats">
          <div class="stats-group">
            <?php if ($product['stat1']): ?>
              <span class="stat-1"><span class="stats-label"><?php echo $product['stat1']['label']; ?>:</span> <span><?php echo $product['stat1']['text']; ?></span></span>
            <?php endif; ?>
            <?php if ($product['stat2']): ?>
              <span class="stat-2"><span class="stats-label"><?php echo $product['stat2']['label']; ?>:</span> <span><?php echo $product['stat2']['text']; ?></span></span>
            <?php endif; ?>
          </div>
          </div>
        <?php endif; ?>

        <?php if ($journal3->getIn($prefix . 'NamePosition', $context) == "default"): ?>
          <div class="name"><a href="<?php echo $product['href']; ?>" title="<?php echo $product['name']; ?>"><?php echo $product['name']; ?></a></div>
        <?php endif; ?>

        <?php if (!empty($product['description']) && $product['description'] !== '..') { ?>
        <div class="description"><?php echo $product['description']; ?></div>
        <?php } ?>

        <?php if ($product['price']): ?>
          <div class="price">
            <?php if (!empty($product['labels']['price'])): ?>
              <span class="product-labels-price">
                <?php foreach ($product['labels']['price'] as $id => $label): ?>
                    <span class="product-label product-label-<?php echo $id; ?> product-label-<?php echo $label['display']; ?> <?php echo $journal3->classes(\Journal3\Utils\Arr::get($label, 'classes')); ?>"><strong><?php echo $label['label']; ?></strong></span>
                <?php endforeach; ?>
              </span>
            <?php endif; ?>
            <div>
              <?php if ($product['special']): ?>
                <span class="price-new"><?php echo $product['special']; ?></span> <span class="price-old"><?php echo $product['price']; ?></span>
              <?php else: ?>
                <span class="price-normal"><?php echo $product['price']; ?></span>
              <?php endif; ?>
            </div>
            <?php if ($product['tax']): ?>
              <span class="price-tax"><?php echo $text_tax; ?><?php echo $product['tax']; ?></span>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <?php if ($product['rating']): ?>
          <div class="rating <?php if ($journal3->getIn($prefix . 'RatingPosition', $context) == "hover"): ?>rating-hover<?php endif; ?>">
            <div class="rating-stars">
              <?php for ($i = 1; $i <= 5; $i++): ?>
                <?php if ($product['rating'] < $i): ?>
                  <span class="fa fa-stack"><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php else: ?>
                  <span class="fa fa-stack"><em class="fa fa-star fa-stack-2x"></em><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php endif; ?>
              <?php endfor; ?>
            </div>
          </div>
        <?php else: ?>
          <div class="rating no-rating <?php if ($journal3->getIn($prefix . 'RatingPosition', $context) == "hover"): ?>rating-hover<?php endif; ?>">
            <div class="rating-stars">
              <?php for ($i = 1; $i <= 5; $i++): ?>
                <?php if ($product['rating'] < $i): ?>
                  <span class="fa fa-stack"><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php else: ?>
                  <span class="fa fa-stack"><em class="fa fa-star fa-stack-2x"></em><em class="fa fa-star-o fa-stack-2x"></em></span>
                <?php endif; ?>
              <?php endfor; ?>
            </div>
          </div>
        <?php endif; ?>

        <?php if ($journal3->get('catalogCartStatus') || $journal3->get('catalogWishlistStatus') || $journal3->get('catalogCompareStatus')): ?>
        <div class="buttons-wrapper">
          <div class="button-group">
            <?php if ($journal3->get('catalogCartStatus')): ?>
            <div class="cart-group">
              <div class="stepper">
                <label class="sr-only" for="<?php echo $product['qid']; ?>"><?php echo $product['name']; ?></label>
                <button aria-label="-" class="fa fa-angle-down"></button>
                <input id="<?php echo $product['qid']; ?>" type="text" name="quantity" value="<?php echo $product['minimum']; ?>" data-minimum="<?php echo $product['minimum']; ?>" class="form-control"/>
                <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>"/>
                <button aria-label="+" class="fa fa-angle-up"></button>
              </div>
              <a class="btn btn-cart" role="button" aria-label="<?php echo $product['button_cart']; ?>" <?php if ($journal3->is_desktop && ($journal3->getIn($prefix . 'CartDisplay', $context) == "icon") && ($journal3->getIn($prefix . 'CartTooltipStatus', $context))): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo isset($module_id) ? 'module-products-' . $module_id . ' module-products-grid' : 'product-grid'; ?> cart-tooltip" data-placement="<?php echo $journal3->getIn($prefix . 'CartTooltipPosition', $context); ?>" title="<?php echo $product['button_cart']; ?>" <?php endif; ?> onclick="cart.add('<?php echo $product['product_id']; ?>', $(this).closest('.product-thumb').find('.button-group input[name=\'quantity\']').val());" data-loading-text="<span class='btn-text'><?php echo $product['button_cart']; ?></span>"><span class="btn-text"><?php echo $product['button_cart']; ?></span></a>
            </div>
            <?php endif; ?>

            <?php if ($journal3->get('catalogWishlistStatus') || $journal3->get('catalogCompareStatus')): ?>
            <div class="wish-group">
              <?php if ($journal3->get('catalogWishlistStatus')): ?>
              <a class="btn btn-wishlist" role="button" aria-label="<?php echo $button_wishlist; ?>" <?php if ($journal3->is_desktop && ($journal3->getIn($prefix . 'WishlistDisplay', $context) == "icon") && ($journal3->getIn($prefix . 'WishlistTooltipStatus', $context))): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo isset($module_id) ? 'module-products-' . $module_id . ' module-products-grid' : 'product-grid'; ?> wishlist-tooltip" data-placement="<?php echo $journal3->getIn($prefix . 'WishlistTooltipPosition', $context); ?>" title="<?php echo $button_wishlist; ?>" <?php endif; ?> onclick="wishlist.add('<?php echo $product['product_id']; ?>')"><span class="btn-text"><?php echo $button_wishlist; ?></span></a>
              <?php endif; ?>
              <?php if ($journal3->get('catalogCompareStatus')): ?>
              <a class="btn btn-compare" role="button" aria-label="<?php echo $button_compare; ?>" <?php if ($journal3->is_desktop && ($journal3->getIn($prefix . 'CompareDisplay', $context) == "icon") && ($journal3->getIn($prefix . 'CompareTooltipStatus', $context))): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo isset($module_id) ? 'module-products-' . $module_id . ' module-products-grid' : 'product-grid'; ?> compare-tooltip" data-placement="<?php echo $journal3->getIn($prefix . 'CompareTooltipPosition', $context); ?>" title="<?php echo $button_compare; ?>" <?php endif; ?> onclick="compare.add('<?php echo $product['product_id']; ?>')"><span class="btn-text"><?php echo $button_compare; ?></span></a>
              <?php endif; ?>
            </div>
            <?php endif; ?>
          </div>
        </div>
        <?php endif; ?>

        <?php if ($product['extra_buttons']): ?>
          <div class="extra-group">
            <div>
              <?php $index = 0; foreach ($product['extra_buttons'] as $id => $extra_button): $index++; ?>
                <a class="btn btn-extra btn-extra-<?php echo $id; ?>"
                  <?php if ($journal3->is_desktop && ($journal3->getIn($prefix . 'ExtraButtonDisplay' . $index, $context) == "icon") && ($journal3->getIn($prefix . 'ExtraButtonTooltipStatus', $context))): ?> data-toggle="tooltip-hover" data-tooltip-class="<?php echo isset($module_id) ? 'module-products-' . $module_id . ' module-products-grid' : 'product-grid'; ?> extra-tooltip" data-placement="<?php echo $journal3->getIn($prefix . 'ExtraButtonTooltipPosition', $context); ?>" title="<?php echo $extra_button['label']; ?>" <?php endif; ?>
                   <?php if ($extra_button['action'] == 'quickbuy'): ?>onclick="cart.add('<?php echo $product['product_id']; ?>', $(this).closest('.product-thumb').find('.button-group input[name=\'quantity\']').val(), true);"<?php endif; ?>
                   <?php if ($extra_button['action'] == 'link' && $extra_button['link']['href']): ?>href="<?php echo $extra_button['link']['href']; ?>" <?php echo $journal3->linkAttrs($extra_button['link']); ?> data-product_id="<?php echo $product['product_id']; ?>" data-product_url="<?php echo $product['href']; ?>" <?php else: ?>href="javascript:;"<?php endif; ?>
                   data-loading-text="<span class='btn-text'><?php echo $extra_button['label']; ?></span>">
                  <span class="btn-text"><?php echo $extra_button['label']; ?></span>
                </a>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
