<?php if (!function_exists('renderTopMenu')) {
  function renderTopMenu($context, $item) {
    $journal3 = $context['journal3'];
    $image_width = $context['image_width'];
    $image_height = $context['image_height'];
    ?>
    <li class="<?php echo $journal3->classes($item['classes']); ?>">
      <?php if ($item['items']): ?>
        <?php if ($item['link']['href']): ?>
          <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?> class="dropdown-toggle" data-toggle="dropdown" title="<?php echo $item['title']; ?>">
            <?php if (!empty($item['thumb'])): ?>
              <span class="menu-image">
                <img src="<?php echo $item['thumb']; ?>" <?php if (!empty($item['thumb2x'])): ?>srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['title']; ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>"/>
              </span>
              <?php endif; ?>
            <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          </a>
        <?php else: ?>
          <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" title="<?php echo $item['title']; ?>">
            <?php if (!empty($item['thumb'])): ?>
            <span class="menu-image">
              <img src="<?php echo $item['thumb']; ?>" <?php if (!empty($item['thumb2x'])): ?>srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['title']; ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>"/>
            </span>
            <?php endif; ?>
            <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          </a>
        <?php endif; ?>
        <div class="dropdown-menu j-dropdown <?php echo $item['dropdown_color_scheme'] ?: $context['dropdown_color_scheme'];?>">
          <ul class="j-menu">
            <?php foreach ($item['items'] as $subitem): ?>
              <?php renderTopMenu($context, $subitem); ?>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php else: ?>
        <?php if ($item['link']['href']): ?>
          <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?> title="<?php echo $item['title']; ?>">
            <?php if (!empty($item['thumb'])): ?>
             <span class="menu-image">
                <img src="<?php echo $item['thumb']; ?>" <?php if (!empty($item['thumb2x'])): ?>srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['title']; ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>"/>
             </span>
            <?php endif; ?>
            <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          </a>
        <?php else: ?>
          <a href="javascript:;" title="<?php echo $item['title']; ?>">
            <?php if (!empty($item['thumb'])): ?>
            <span class="menu-image">
              <img src="<?php echo $item['thumb']; ?>" <?php if (!empty($item['thumb2x'])): ?>srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['title']; ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>"/>
            </span>
            <?php endif; ?>
            <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          </a>
        <?php endif; ?>
      <?php endif; ?>
    </li>
    <?php
  }
} ?>
<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <ul class="j-menu">
    <?php foreach ($items as $item): ?>
      <?php renderTopMenu(get_defined_vars(), $item); ?>
    <?php endforeach; ?>
  </ul>
</div>
