<?php if (!function_exists('renderTestimonials')) {
  function renderTestimonials($context, $item) {
    $journal3 = $context['journal3'];
    ?>
    <div class="block-body">
      <?php if ($item['header'] == 'image'): ?>
        <div class="block-header"><img src="<?php echo $item['image']; ?>" alt="" class="block-image" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>"/></div>
      <?php elseif ($item['header'] == 'icon'): ?>
        <div class="block-header"><em class="icon icon-block"></em></div>
      <?php endif; ?>
      <div class="block-content block-<?php echo $item['contentType']; ?>"><?php echo $item['content']; ?></div>
      <?php if ($item['expandButton']): ?>
        <div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div>
      <?php endif; ?>
    </div>
    <?php if ($item['footerText']): ?>
      <div class="block-footer"><?php echo $item['footerText']; ?></div>
    <?php endif; ?>
    <?php
  }
} ?>
<div class="<?php echo $journal3->classes($classes); ?> <?php echo $color_scheme_module; ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php /* grid */ ?>
    <?php if ($display == 'grid') { ?>
      <?php if ($gridType == 'ipr' && $carousel) { ?>
        <div class="swiper" data-items-per-row='<?php echo json_encode($itemsPerRow, JSON_FORCE_OBJECT); ?>' data-options='<?php echo json_encode($carouselOptions, JSON_FORCE_OBJECT); ?>'>
          <div class="swiper-container" <?php if ($journal3->is_rtl): ?>dir="rtl"<?php endif; ?>>
            <div class="swiper-wrapper ipr-grid">
              <?php foreach ($items as $item): ?>
                <div class="<?php echo $journal3->classes($item['classes']); ?>">
                  <?php renderTestimonials(get_defined_vars(), $item); ?>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
          <div class="swiper-buttons">
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
          </div>
          <div class="swiper-pagination"></div>
        </div>
      <?php } else { ?>
        <div class="no-scroll <?php echo $gridType; ?>-grid">
          <?php if ($gridType == 'auto') { ?>
            <div class="auto-grid-items">
              <?php foreach ($items as $item): ?>
                <div class="<?php echo $journal3->classes($item['classes']); ?>">
                  <?php renderTestimonials(get_defined_vars(), $item); ?>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
            <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
          <?php } else { ?>
            <?php foreach ($items as $item): ?>
              <div class="<?php echo $journal3->classes($item['classes']); ?>">
                <?php renderTestimonials(get_defined_vars(), $item); ?>
              </div>
            <?php endforeach; ?>
          <?php } ?>
        </div>
      <?php } ?>
    <?php } ?>
    <?php /* tabs */ ?>
    <?php if ($display == 'tabs'): ?>
      <div class="tab-container">
        <div class="full-tabs-bg"></div>
        <ul class="nav nav-tabs">
          <?php $index = 1;
          foreach ($items as $item): ?>
            <li class="<?php echo $journal3->classes($item['tab_classes']); ?>">
              <?php if ($item['tabType'] == 'link'): ?>
                <a href="<?php echo $item['link']['href'];
                $index++; ?>"><?php echo $item['title']; ?></a>
              <?php else: ?>
                <a href="#<?php echo $id; ?>-tab-<?php echo $index++; ?>" data-toggle="tab"><?php echo $item['title']; ?></a>
              <?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
        <div class="tab-content">
          <?php $index = 1;
          foreach ($items as $item): ?>
            <div class="<?php echo $journal3->classes($item['classes']); ?>" id="<?php echo $id; ?>-tab-<?php echo $index++; ?>">
              <?php renderTestimonials(get_defined_vars(), $item); ?>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>
    <?php /* accordion */ ?>
    <?php if ($display == 'accordion'): ?>
      <div class="panel-group" id="<?php echo $id; ?>-collapse">
        <?php $index = 0;
        foreach ($items as $item): $index++; ?>
          <div class="<?php echo $journal3->classes($item['classes']); ?>">
            <div class="panel-heading">
              <h4 class="panel-title">
                <a href="#<?php echo $id; ?>-collapse-<?php echo $index; ?>" class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#<?php echo $id; ?>-collapse" aria-expanded="false">
                  <?php echo $item['title']; ?>
                  <i class="fa fa-caret-down"></i>
                </a>
              </h4>
            </div>
            <div class="<?php echo $journal3->classes($item['panel_classes']); ?>" id="<?php echo $id; ?>-collapse-<?php echo $index; ?>">
              <div class="panel-body">
                <?php renderTestimonials(get_defined_vars(), $item); ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
