<?php if ($display === 'tabs'): ?>
  <div class="tab-container <?php echo $journal3->classes($classes); ?>">
    <div class="full-tabs-bg"></div>
    <ul class="nav nav-tabs">
      <?php foreach ($items as $item): ?>
        <li class="<?php echo $journal3->classes($item['tab_classes']); ?>">
          <?php if ($item['tabType'] === 'link'): ?>
            <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?>><?php echo $item['title']; ?></a>
          <?php else: ?>
            <a href="#<?php echo $item['id']; ?>" data-toggle="tab"><?php echo $item['title']; ?></a>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
    <div class="tab-content">
      <?php foreach ($items as $item): ?>
        <div class="<?php echo $journal3->classes($item['classes']); ?>" id="<?php echo $item['id']; ?>">
          <div class="block-body expand-block">
            <div class="block-wrapper">
              <div class="block-content <?php if ($item['expandButton']): ?>expand-content<?php endif; ?>">
                <?php echo $item['content']; ?>
                <?php if ($item['expandButton']): ?>
                  <div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php elseif ($display === 'accordion'): ?>
  <div class="panel-group <?php echo $journal3->classes($classes); ?>">
    <?php foreach ($items as $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>">
        <div class="panel-heading">
          <h4 class="panel-title">
            <a href="#<?php echo $item['id']; ?>" class="accordion-toggle collapsed" data-toggle="collapse" aria-expanded="false">
              <?php echo $item['title']; ?>
              <i class="fa fa-caret-down"></i>
            </a>
          </h4>
        </div>
        <div class="<?php echo $journal3->classes($item['panel_classes']); ?>" id="<?php echo $item['id']; ?>">
          <div class="panel-body expand-block">
            <div class="block-wrapper">
              <div class="block-content <?php if ($item['expandButton']): ?>expand-content<?php endif; ?>">
                <?php echo $item['content']; ?>
                <?php if ($item['expandButton']): ?>
                  <div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php else: ?>
  <div class="<?php echo $journal3->classes($classes); ?>">
    <?php foreach ($items as $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>">
        <?php if ($item['popup']) { ?>
          <button data-open-popup="#<?php echo $item['id']; ?>-popup" class="btn product-blocks-popup-btn"><?php echo $item['title']; ?></button>
          <template id="<?php echo $item['id']; ?>-popup">
            <div class="popup-wrapper popup-block <?php echo $journal3->classes($item['popup_classes']); ?>">
              <div class="journal-loading"><em class="fa fa-spinner fa-spin"></em></div>
              <div class="popup-container">
                <div class="popup-body">
                  <div class="popup-inner-body">
                    <button class="btn popup-close"></button>
                    <div class="block-body popup-content">
                      <div class="block-content">
                        <?php echo $item['content']; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="popup-bg popup-bg-closable"></div>
            </div>
          </template>
        <?php } else { ?>
          <?php if ($item['title']): ?>
            <h3 class="title module-title"><?php echo $item['title']; ?></h3>
          <?php endif; ?>
          <div class="block-body expand-block">
            <div class="block-wrapper">
              <div class="block-content <?php if ($item['expandButton']): ?>expand-content<?php endif; ?>">
                <?php echo $item['content']; ?>
                <?php if ($item['expandButton']): ?>
                  <div class="block-expand-overlay"><a class="block-expand btn" role="button" aria-label="<?php echo $journal3->get('globalExpandButtonText'); ?>"></a></div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php } ?>

      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
