<?php if ($iframe): ?>
  <?php if ($contentType === 'image'): ?>
    <div class="popup-content">
      <img src="<?php echo $image; ?>" alt="" width="<?php echo $imageDimensions['width']; ?>" height="<?php echo $imageDimensions['height']; ?>"/>
    </div>
  <?php elseif ($contentType === 'text'): ?>
    <div class="popup-content">
      <?php echo $text; ?>
    </div>
  <?php else: ?>
    <?php echo $content; ?>
  <?php endif; ?>
<?php else: ?>
  <div class="popup-wrapper <?php echo $journal3->classes($classes); ?>" data-options='<?php echo json_encode($options, JSON_FORCE_OBJECT); ?>'>
    <div class="journal-loading"><em class="fa fa-spinner fa-spin"></em></div>
    <div class="popup-container">
      <div class="popup-body">
        <div class="popup-inner-body">
          <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
          <?php if ($closeButton): ?>
            <button class="btn popup-close" aria-label="Close"></button>
          <?php endif; ?>
          <?php if ($headerText): ?>
            <div class="title popup-header"><?php echo $headerText; ?></div>
          <?php endif; ?>

          <?php if ($ajax && $contentType === 'grid'): ?>
            <iframe src="<?php echo $iframe_src; ?>" width="100%" height="100%" frameborder="0" onload="update_popup_height(this)"></iframe>
          <?php elseif ($contentType === 'image'): ?>
            <div class="popup-content">
              <img src="<?php echo $image; ?>" alt="" width="<?php echo $imageDimensions['width']; ?>" height="<?php echo $imageDimensions['height']; ?>"/>
            </div>
          <?php elseif ($contentType === 'text'): ?>
            <div class="popup-content">
              <?php echo $text; ?>
            </div>
          <?php else: ?>
            <div class="popup-content">
              <?php echo $content; ?>
            </div>
          <?php endif; ?>

          <?php if ($footer): ?><div class="popup-footer"><?php if ($button1 || $button2): ?><div class="popup-buttons">
                  <?php if ($button1): ?>
                    <a class="btn btn-popup btn-popup-1"<?php if ($button1Link['href']): ?> href="<?php echo $button1Link['href']; ?>"<?php endif; ?>><span class="btn-text"><?php echo $button1Text; ?></span></a>
                  <?php endif; ?>

                  <?php if ($button2): ?>
                    <a class="btn btn-popup btn-popup-2"<?php if ($button2Link['href']): ?> href="<?php echo $button2Link['href']; ?>"<?php endif; ?>><span class="btn-text"><?php echo $button2Text; ?></span></a>
                  <?php endif; ?>
                </div><?php endif; ?><?php if (!$ajax && $doNotShowAgain): ?><label class="popup-dont-show" for="popup-checkbox-el-<?php echo $id; ?>">
                  <input id="popup-checkbox-el-<?php echo $id; ?>" type="checkbox" <?php if ($doNotShowAgainChecked): ?>checked<?php endif; ?>>
                  <span><?php echo $doNotShowAgainText; ?></span>
                </label><?php endif; ?></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="popup-bg <?php if ($closeButton): ?>popup-bg-closable<?php endif; ?>"></div>
  </div>
<?php endif; ?>
