<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <div class="journal-loading"><em class="fa fa-spinner fa-spin"></em></div>
  <?php if (isset($staticText)): ?>
    <?php if ($staticText && $staticTextLink['href']): ?>
      <a href="<?php echo $staticTextLink['href']; ?>" class="slider-static-text static-text-1"><span><?php echo $staticText; ?></span></a>
    <?php elseif ($staticText) : ?>
      <div class="slider-static-text static-text-1"><span><?php echo $staticText; ?></span></div>
    <?php endif; ?>
  <?php endif; ?>
  <?php if (isset($static2Text)): ?>
    <?php if ($static2Text && $static2TextLink['href']): ?>
      <a href="<?php echo $static2TextLink['href']; ?>" class="slider-static-text static-text-2"><span><?php echo $static2Text; ?></span></a>
    <?php elseif ($static2Text) : ?>
      <div class="slider-static-text static-text-2"><span><?php echo $static2Text; ?></span></div>
    <?php endif; ?>
  <?php endif; ?>
  <img src="<?php echo $lazyload_placeholder; ?>" alt="<?php echo $first_alt; ?>" width="<?php echo $width; ?>" height="<?php echo $height; ?>" />
  <div class="master-slider ms-skin-minimal" data-options='<?php echo json_encode($options, JSON_FORCE_OBJECT); ?>' <?php if ($parallaxMode): ?>data-parallax="<?php echo $parallax; ?>"<?php endif; ?>>
    <?php $first_key = array_keys($items)[0]; ?>
    <?php foreach ($items as $index => $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>" <?php if ($item['delay']): ?>data-delay="<?php echo $item['delay']; ?>"<?php endif; ?>>
        <?php if ($lazyLoad || $first_key !== $index): ?>
          <img class="lazyload" src="<?php echo $lazyload_placeholder; ?>" data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $width; ?>" height="<?php echo $height; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
        <?php else: ?>
          <img src="<?php echo $item['image']; ?>" srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $width; ?>" height="<?php echo $height; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
        <?php endif; ?>

        <?php if ($thumbnails && $item['thumb']): ?>
          <img src="<?php echo $item['thumb']; ?>" <?php if (isset($item['thumb2x']) && $item['thumb2x']): ?> srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x"<?php endif; ?> alt="<?php echo $item['alt']; ?>" class="ms-thumb"/>
        <?php endif; ?>

        <?php if ($item['link']['href']): ?>
          <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?> aria-hidden="true" tabindex="-1"></a>
        <?php endif; ?>

        <?php if ($item['type'] == 'video'): ?>
          <?php if ($item['videoType'] == 'html5'): ?>
            <video autoplay playsinline muted data-src="<?php echo $item['videoSrc']; ?>"></video>
          <?php elseif ($item['videoType'] == 'youtube'): ?>
            <a href="https://www.youtube.com/embed/<?php echo $item['videoSrc']; ?>?hd=1&wmode=opaque&controls=1&showinfo=0&autoplay=1" data-type="video"></a>
          <?php elseif ($item['videoType'] == 'vimeo'): ?>
            <a href="https://player.vimeo.com/video/<?php echo $item['videoSrc']; ?>" data-type="video"></a>
          <?php endif; ?>
        <?php endif; ?>

        <?php foreach ($item['items'] as $subitem): ?>
          <?php if ($subitem['type'] == 'text'): ?>
            <div class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?>><?php echo $subitem['text']; ?></div>
          <?php elseif ($subitem['type'] == 'hotspot'): ?>
            <div class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?>>
              <div class="product-tt"><?php echo $subitem['text']; ?></div>
            </div>
          <?php elseif ($subitem['type'] == 'shape'): ?>
            <img class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?> src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" alt="<?php echo $subitem['alt']; ?>"/>
          <?php elseif ($subitem['type'] == 'button'): ?>
            <a class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?> <?php if ($subitem['link']['href']): ?>href="<?php echo $subitem['link']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['link']); ?><?php else: ?>href="javascript:;"<?php endif; ?>><span><?php echo $subitem['text']; ?></span></a>
          <?php elseif ($subitem['type'] == 'image'): ?>
            <img class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?> src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="<?php echo $subitem['image']; ?>" alt="<?php echo $subitem['alt']; ?>" width="<?php echo $subitem['width']; ?>" height="<?php echo $subitem['height']; ?>"/>
          <?php elseif ($subitem['type'] == 'video'): ?>
            <div class="<?php echo $journal3->classes($subitem['classes']); ?>" <?php echo implode(' ', $subitem['data']); ?>>
              <?php if ($subitem['videoType'] == 'html5'): ?>
                <video autoplay playsinline muted controls data-src="<?php echo $subitem['videoSrc']; ?>"></video>
              <?php elseif ($subitem['videoType'] == 'youtube'): ?>
                <iframe data-src="https://www.youtube.com/embed/<?php echo $subitem['videoSrc']; ?>?hd=1&wmode=opaque&controls=1&showinfo=0"></iframe>
              <?php elseif ($subitem['videoType'] == 'vimeo'): ?>
                <iframe data-src="https://player.vimeo.com/video/<?php echo $subitem['videoSrc']; ?>"></iframe>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        <?php endforeach; ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>
