<?php if (!function_exists('renderManufacturers')) {
  function renderManufacturers($context, $item) {
    $journal3 = $context['journal3'];
    if ($context['gridType'] == 'ipr' && $context['swiper_carousel']): ?>
      <div class="swiper" data-items-per-row='<?php echo json_encode($context['itemsPerRow'], JSON_FORCE_OBJECT); ?>' data-options='<?php echo json_encode($context['carouselOptions'], JSON_FORCE_OBJECT); ?>'>
        <div class="swiper-container" <?php if ($journal3->is_rtl): ?>dir="rtl"<?php endif; ?>>
          <div class="swiper-wrapper manufacturer-grid ipr-grid <?php echo $context['color_scheme_content']; ?>">
            <?php echo $item['manufacturers']; ?>
          </div>
        </div>
        <div class="swiper-buttons">
          <div class="swiper-button-prev"></div>
          <div class="swiper-button-next"></div>
        </div>
        <div class="swiper-pagination"></div>
      </div>
    <?php else: ?>
      <div class="manufacturer-grid no-scroll <?php echo $context['gridType']; ?>-grid <?php if ($context['gridType'] == "flex") { echo $context['color_scheme_content']; } ?>">
        <?php if ($context['gridType'] == 'auto') { ?>
          <div class="auto-grid-items <?php echo $context['color_scheme_content']; ?>">
            <?php echo $item['manufacturers']; ?>
          </div>
          <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
          <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
        <?php } else { ?>
          <?php echo $item['manufacturers']; ?>
        <?php } ?>
      </div>
    <?php endif;
  }
} ?>
<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php /* grid */; ?>
    <?php if ($sectionsDisplay == 'blocks'): ?>
      <?php foreach ($items as $item): ?>
        <div class="<?php echo $journal3->classes($item['classes']); ?>">
          <?php if ($item['title']): ?>
            <h3 class="title module-title"><?php echo $item['title']; ?></h3>
          <?php endif; ?>
          <?php renderManufacturers(get_defined_vars(), $item); ?>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
    <?php /* tabs */; ?>
    <?php if ($sectionsDisplay == 'tabs'): ?>
      <div class="tab-container">
        <div class="full-tabs-bg"></div>
        <ul class="nav nav-tabs">
          <?php foreach ($items as $item): ?>
            <li class="<?php echo $journal3->classes($item['tab_classes']); ?>">
              <?php if ($item['tabType'] == 'link'): ?>
                <a href="<?php echo $item['link']['href']; ?>"><?php echo $item['title']; ?></a>
              <?php else: ?>
                <a href="#<?php echo $id; ?>-tab-<?php echo $item['index']; ?>" data-toggle="tab"><?php echo $item['title']; ?></a>
              <?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
        <div class="tab-content">
          <?php foreach ($items as $item): ?>
            <?php if ($item['tabType'] != 'link'): ?>
              <?php if ($item['active']) { ?>
                <div class="<?php echo $journal3->classes($item['classes']); ?>" id="<?php echo $id; ?>-tab-<?php echo $item['index']; ?>">
                  <?php renderManufacturers(get_defined_vars(), $item); ?>
                </div>
              <?php } else { ?>
                <template class="<?php echo $journal3->classes($item['classes']); ?>" id="<?php echo $id; ?>-tab-<?php echo $item['index']; ?>">
                  <?php renderManufacturers(get_defined_vars(), $item); ?>
                </template>
              <?php } ?>
            <?php endif; ?>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>
    <?php /* accordion */; ?>
    <?php if ($sectionsDisplay == 'accordion'): ?>
      <div class="panel-group" id="<?php echo $id; ?>-collapse">
        <?php foreach ($items as $item): ?>
          <div class="<?php echo $journal3->classes($item['classes']); ?>">
            <div class="panel-heading">
              <h4 class="panel-title">
                <a href="#<?php echo $id; ?>-collapse-<?php echo $item['index']; ?>" class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#<?php echo $id; ?>-collapse" aria-expanded="false">
                  <?php echo $item['title']; ?>
                  <i class="fa fa-caret-down"></i>
                </a>
              </h4>
            </div>
            <div class="<?php echo $journal3->classes($item['panel_classes']); ?>" id="<?php echo $id; ?>-collapse-<?php echo $item['index']; ?>">
              <?php if ($item['active']) { ?>
                <div class="panel-body">
                  <?php renderManufacturers(get_defined_vars(), $item); ?>
                </div>
              <?php } else { ?>
                <template class="panel-body">
                  <?php renderManufacturers(get_defined_vars(), $item); ?>
                </template>
              <?php } ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
