<?php if (!function_exists('renderLinksMenu')) {
  function renderLinksMenu($context, $item) {
    $journal3 = $context['journal3'];
    ?>
    <li class="<?php echo $journal3->classes($item['classes']); ?> <?php if ($item['isTitle']): ?>is-title<?php endif; ?>">
      <?php if ($item['link']['href']): ?>
        <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?>>
          <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          <?php if (isset($item['label']) && $item['label']): ?>
            <span class="menu-label"><?php echo $item['label']; ?></span>
          <?php endif; ?>
        </a>
      <?php else: ?>
        <a href="javascript:;">
          <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
          <?php if (isset($item['label']) && $item['label']): ?>
            <span class="menu-label"><?php echo $item['label']; ?></span>
          <?php endif; ?>
        </a>
      <?php endif; ?>
    </li>
    <?php
  }
} ?>
<?php if ($items): ?>
  <div class="<?php echo $journal3->classes($classes); ?>">
    <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
    <?php if ($title): ?>
      <h3 class="title module-title"><?php echo $title; ?></h3>
    <?php endif; ?>
    <ul class="module-body">
      <?php foreach ($items as $item): ?>
        <?php renderLinksMenu(get_defined_vars(), $item); ?>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>
