<?php if (!function_exists('renderInfoBlocks')):
  function renderInfoBlocks($context, $item) {
    $journal3 = $context['journal3'];
    ?>
    <?php if ($item['link']['href']): ?>
      <a href="<?php echo $item['link']['href']; ?>" class="info-block" <?php echo $journal3->linkAttrs($item['link']); ?> title="<?php echo $item['title']; ?>">
        <?php if ($item['type'] === 'image'): ?>
          <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?> srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>" alt="<?php echo $item['title']; ?>" class="info-block-img"/>
        <?php endif; ?>
        <?php if ($item['type'] === 'counter'): ?>
          <div class="info-block-counter">
            <?php echo $item['counter']; ?>
          </div>
        <?php endif; ?>
        <div class="info-block-content">
          <div class="info-block-title"><?php echo $item['title']; ?></div>
          <div class="info-block-text"><?php echo $item['content']; ?></div>
          <div class="btn info-block-button"><?php echo $item['buttonTextNew']; ?></div>
        </div>
        <?php if ($item['link']['total'] !== null): ?>
          <span class="count-badge"><?php echo $item['link']['total']; ?></span>
        <?php endif; ?>
      </a>
    <?php else: ?>
      <div class="info-block">
        <?php if ($item['type'] === 'image'): ?>
          <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?> srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>" alt="<?php echo $item['title']; ?>" class="info-block-img"/>
        <?php endif; ?>
        <?php if ($item['type'] === 'counter'): ?>
          <div class="info-block-counter">
            <?php echo $item['counter']; ?>
          </div>
        <?php endif; ?>
        <div class="info-block-content">
          <div class="info-block-title"><?php echo $item['title']; ?></div>
          <div class="info-block-text"><?php echo $item['content']; ?></div>
          <a class="btn info-block-button" href="<?php echo $item['buttonLink']['href'] ?: 'javascript:;'; ?>" <?php echo $journal3->linkAttrs($item['buttonLink']); ?>><?php echo $item['buttonTextNew']; ?></a>
        </div>
      </div>
    <?php endif; ?>
    <?php
  }
endif; ?>
<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
    <?php if ($title): ?>
      <h3 class="title module-title"><?php echo $title; ?></h3>
    <?php endif; ?>
  <?php if ($description): ?>
    <p class="module-description"><?php echo $description; ?></p>
  <?php endif; ?>
  <div class="module-body">
    <div class="info_blocks-grid no-scroll <?php echo $gridType; ?>-grid">
      <?php if ($gridType == 'auto') { ?>
        <div class="auto-grid-items">
          <?php foreach ($items as $item): ?>
            <div class="<?php echo $journal3->classes($item['classes']); ?>">
              <?php renderInfoBlocks(get_defined_vars(), $item); ?>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
        <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
      <?php } else { ?>
        <?php foreach ($items as $item): ?>
          <div class="<?php echo $journal3->classes($item['classes']); ?>">
            <?php renderInfoBlocks(get_defined_vars(), $item); ?>
          </div>
        <?php endforeach; ?>
      <?php } ?>
    </div>
  </div>
</div>
