<?php if ($items): ?>
  <div class="<?php echo $journal3->classes($classes); ?>">
    <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
    <?php if ($title): ?>
      <h3 class="title module-title"><?php echo $title; ?></h3>
    <?php endif; ?>
    <ul>
      <?php foreach ($items as $item): ?>
        <li class="<?php echo $journal3->classes($item['classes']); ?>">
          <?php if ($item['link']['href']): ?>
            <a <?php if ($journal3->is_desktop && $tooltipStatus): ?>data-toggle="tooltip-hover" data-tooltip-class="icons-menu-tooltip-<?php echo $module_id; ?>" data-placement="<?php echo $tooltipPosition; ?>" data-selector="true" data-title="<?php echo $item['title']; ?>"<?php endif; ?> title="<?php echo $item['title']; ?>" href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?>>
              <?php if ($item['type'] === 'image'): ?>
                <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?> srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> width="<?php echo $imageDimensions['width']; ?>" height="<?php echo $imageDimensions['height']; ?>" alt="<?php echo $item['title']; ?>" class="info-block-img"/>
              <?php endif; ?>
              <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
            </a>
          <?php else: ?>
            <a href="javascript:;">
              <?php if ($item['type'] === 'image'): ?>
                <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?> srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> width="<?php echo $imageDimensions['width']; ?>" height="<?php echo $imageDimensions['height']; ?>" alt="<?php echo $item['title']; ?>" class="info-block-img"/>
              <?php endif; ?>
              <?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?>
            </a>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>
