<?php if (!function_exists('renderGallery')) {
  function renderGallery($context) {
    $journal3 = $context['journal3'];
    $index = 0;
    $items = array_slice($context['items'], 0, $context['thumbsLimit']);
    foreach ($items as $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>">
        <a <?php if ($item['type'] == 'link'): ?>href="<?php echo $item['popup']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?><?php else: ?>href="javascript:;" data-gallery="#<?php echo $context['id']; ?> .lightgallery" data-index="<?php echo $index++; ?>"<?php endif; ?> title="<?php echo $item['alt']; ?>">
          <span class="gallery-image">
            <?php if ($journal3->get('performanceLazyLoadImagesStatus')): ?>
              <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $item['thumb']; ?>" <?php if (isset($item['thumb2x']) && $item['thumb2x']): ?>data-srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x"<?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $context['thumbDimensions']['width']; ?>" height="<?php echo $context['thumbDimensions']['height']; ?>" class="lazyload"/>
            <?php else: ?>
              <img src="<?php echo $item['thumb']; ?>" <?php if (isset($item['thumb2x']) && $item['thumb2x']): ?>srcset="<?php echo $item['thumb']; ?> 1x, <?php echo $item['thumb2x']; ?> 2x"<?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $context['thumbDimensions']['width']; ?>" height="<?php echo $context['thumbDimensions']['height']; ?>"/>
            <?php endif; ?>
          </span>
        </a>
        <?php if ($item['alt']): ?>
        <span class="gallery-image-caption">
          <?php echo $item['alt']; ?>
        </span>
        <?php endif; ?>
      </div>
    <?php endforeach;
  }
} ?>
<div id="<?php echo $id; ?>" class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php if ($button): ?>
      <a class="btn open-btn" data-gallery="#<?php echo $id; ?> .lightgallery" data-index="0" role="button"><?php echo $buttonText; ?></a>
    <?php else: ?>
      <?php /* grid */ ?>
      <?php if ($gridType == 'ipr' && $carousel) { ?>
        <div class="swiper" data-items-per-row='<?php echo json_encode($itemsPerRow, JSON_FORCE_OBJECT); ?>' data-options='<?php echo json_encode($carouselOptions, JSON_FORCE_OBJECT); ?>'>
          <div class="swiper-container" <?php if ($journal3->is_rtl): ?>dir="rtl"<?php endif; ?>>
            <div class="swiper-wrapper">
              <?php renderGallery(get_defined_vars()); ?>
            </div>
          </div>
          <div class="swiper-buttons">
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
          </div>
          <div class="swiper-pagination"></div>
        </div>
      <?php } else { ?>
        <div class="gallery-grid no-scroll <?php echo $gridType; ?>-grid">
          <?php if ($gridType == 'auto') { ?>
            <div class="auto-grid-items">
              <?php renderGallery(get_defined_vars()); ?>
            </div>
            <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
            <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
          <?php } else { ?>
            <?php renderGallery(get_defined_vars()); ?>
          <?php } ?>
        </div>
      <?php } ?>
    <?php endif; ?>
  </div>
  <div class="lightgallery" data-images='<?php echo htmlspecialchars(json_encode($images), ENT_QUOTES, 'UTF-8'); ?>' data-options='<?php echo json_encode($options, JSON_FORCE_OBJECT); ?>'></div>
</div>
