<?php if (!function_exists('renderCatalogBlocks')):
  function renderCatalogBlocks($context, $item) {
    $journal3 = $context['journal3'];
    ?>
    <?php if ($item['blockLink']['href']): ?>
      <a class="block-link" href="<?php echo $item['blockLink']['href']; ?>" <?php echo $journal3->linkAttrs($item['blockLink']); ?> aria-hidden="true" tabindex="-1"></a>
    <?php endif; ?>
    <?php if ($context['display'] == 'grid' && $item['title'] && $context['titlePosition'] == 'block'): ?>
      <h3 class="title module-title block-title">
        <span><?php echo $item['title']; ?></span>
        <?php if (!empty($item['href'])): ?>
          <a href="<?php echo $item['href']; ?>" class="item-all-link"><span><?php echo $context['allLinkText']; ?></span></a>
        <?php endif; ?>
      </h3>
    <?php endif; ?>
    <div class="block-body">
    <?php if ($item['header'] != 'none'): ?>
      <div class="block-header">
        <div class="block-header-data">
          <a class="block-header-link" href="<?php echo $item['blockHeaderLink']['href'] ?: ($item['href'] ?? ''); ?>" <?php echo $journal3->linkAttrs($item['blockHeaderLink']); ?>>
            <?php if ($item['header'] == 'image'): ?>
              <div class="block-header-image">
                <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $context['lazyLoad']): ?>
                  <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $context['imageDimensionsFeatured']['width']; ?>" height="<?php echo $context['imageDimensionsFeatured']['height']; ?>" class="block-image lazyload">
                <?php else: ?>
                  <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $context['imageDimensionsFeatured']['width']; ?>" height="<?php echo $context['imageDimensionsFeatured']['height']; ?>" class="block-image">
                <?php endif; ?>
                <?php if ($context['display'] == 'grid' && $context['titlePosition'] == 'before' && $item['title']): ?>
                  <h3 class="title module-title block-title"><?php echo $item['title']; ?></h3>
                <?php endif; ?>
              </div>
            <?php elseif ($item['header'] == 'icon'): ?>
              <div class="block-head-icon">
                <em class="icon icon-block"></em>
                <?php if ($context['display'] == 'grid' && $context['titlePosition'] == 'before' && $item['title']): ?>
                  <h3 class="title module-title block-title"><?php echo $item['title']; ?></h3>
                <?php endif; ?>
              </div>
            <?php elseif ($item['header'] == 'text'): ?>
              <div class="block-head-text">
                <span class="block-header-text"><?php echo $item['title']; ?></span>
                <?php if ($context['display'] == 'grid' && $context['titlePosition'] == 'before' && $item['title']): ?>
                  <h3 class="title module-title block-title"><?php echo $item['title']; ?></h3>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </a>
          <div class="block-category-data">
            <div class="block-category-name"><?php echo $item['title']; ?></div>
            <div class="block-category-description"><?php echo $item['description'] ?? ''; ?></div>
          </div>
        </div>
        <?php if ($item['footer'] == 'button'): ?>
          <div class="block-footer"><a class="btn" href="<?php echo $item['footerButtonLink']['href'] ?: ($item['href'] ?? ''); ?>" <?php echo $journal3->linkAttrs($item['footerButtonLink']); ?>><span><?php echo $item['footerButton'] ?: $item['title']; ?></span></a></div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

      <div class="block-wrapper">
        <?php if ($context['display'] == 'grid' && $context['titlePosition'] == 'body' && $item['title']): ?>
          <h3 class="title module-title block-title"><?php echo $item['title']; ?></h3>
        <?php endif; ?>
        <?php if ($item['subtype'] != 'none'): ?>
        <div class="block-content block-catalog"><?php if ($item['items']): ?><div class="catalog-blocks <?php echo $context['gridType']; ?>-grid no-scroll">
              <?php if ($context['gridType'] == 'auto'): ?>
              <div class="auto-grid-items">
                <?php foreach ($item['items'] as $subitems): ?>
                  <div class="<?php echo $journal3->classes($subitems['classes']); ?>">
                    <div class="item-content">
                      <a href="<?php echo $subitems['href']; ?>" class="catalog-title"><?php echo $subitems['name']; ?></a>
                      <div class="item-assets image-left">
                        <?php if ($subitems['image']): ?>
                          <a href="<?php echo $subitems['href']; ?>" class="catalog-image">
                            <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $context['lazyLoad']): ?>
                              <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $subitems['image']; ?>" <?php if (isset($subitems['image2x']) && $subitems['image2x']): ?>data-srcset="<?php echo $subitems['image']; ?> 1x, <?php echo $subitems['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $subitems['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>" class="lazyload"/>
                            <?php else: ?>
                              <img src="<?php echo $subitems['image']; ?>" <?php if (isset($subitems['image2x']) && $subitems['image2x']): ?>srcset="<?php echo $subitems['image']; ?> 1x, <?php echo $subitems['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $subitems['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>"/>
                            <?php endif; ?>
                          </a>
                        <?php endif; ?>
                        <div class="subitems">
                          <?php foreach ($subitems['items'] as $sub_item): ?>
                            <div class="subitem" data-image="<?php echo $sub_item['image']; ?>" <?php if (isset($sub_item['image2x']) && $sub_item['image2x']): ?>data-image2x="<?php echo $sub_item['image']; ?> 1x, <?php echo $sub_item['image2x']; ?> 2x"<?php endif; ?>>
                              <a href="<?php echo $sub_item['href']; ?>"><span><?php echo $sub_item['name']; ?></span></a>
                            </div>
                          <?php endforeach; ?>
                          <?php if ($context['viewMoreAlwaysShow'] || $subitems['total'] > count($subitems['items'])): ?>
                            <div class="subitem view-more">
                              <a href="<?php echo $subitems['href']; ?>"><span><?php echo $context['viewMoreText']; ?></span></a>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
              <div class="auto-carousel-bar auto-carousel-controls">
                <div class="auto-carousel-thumb"></div>
                <div class="auto-carousel-fill"></div>
              </div>
              <div class="auto-carousel-buttons auto-carousel-controls">
                <div class="auto-carousel-prev"><span></span></div>
                <div class="auto-carousel-next"><span></span></div>
              </div>
              <?php elseif ($context['gridType'] == 'masonry'): ?>
                <?php foreach ($item['items'] as $subitems): ?>
                  <div class="<?php echo $journal3->classes($subitems['classes']); ?>">
                    <div class="item-content">
                      <a href="<?php echo $subitems['href']; ?>" class="catalog-title"><?php echo $subitems['name']; ?></a>
                      <div class="item-assets image-left">
                        <?php if ($subitems['image']): ?>
                          <a href="<?php echo $subitems['href']; ?>" class="catalog-image">
                            <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $context['lazyLoad']): ?>
                              <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $subitems['image']; ?>" <?php if (isset($subitems['image2x']) && $subitems['image2x']): ?>data-srcset="<?php echo $subitems['image']; ?> 1x, <?php echo $subitems['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $subitems['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>" class="lazyload">
                            <?php else: ?>
                              <img src="<?php echo $subitems['image']; ?>" <?php if (isset($subitems['image2x']) && $subitems['image2x']): ?>srcset="<?php echo $subitems['image']; ?> 1x, <?php echo $subitems['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $subitems['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>">
                            <?php endif; ?>
                          </a>
                        <?php endif; ?>
                        <div class="subitems">
                          <?php foreach ($subitems['items'] as $sub_item): ?>
                            <div class="subitem" data-image="<?php echo $sub_item['image']; ?>" <?php if (isset($sub_item['image2x']) && $sub_item['image2x']): ?>data-image2x="<?php echo $sub_item['image']; ?> 1x, <?php echo $sub_item['image2x']; ?> 2x"<?php endif; ?>>
                              <a href="<?php echo $sub_item['href']; ?>"><span><?php echo $sub_item['name']; ?></span></a>
                            </div>
                          <?php endforeach; ?>
                          <?php if ($context['viewMoreAlwaysShow'] || $subitems['total'] > count($subitems['items'])): ?>
                            <div class="subitem view-more">
                              <a href="<?php echo $subitems['href']; ?>"><span><?php echo $context['viewMoreText']; ?></span></a>
                            </div>
                          <?php endif; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php endif; ?>
            </div><?php elseif ($item['subtype'] == 'custom'): ?><?php echo $item['catalog']; ?><?php else: ?><?php echo $context['noItemsText']; ?><?php endif; ?></div>
        <?php endif; ?>
        <?php if ($item['products'] && $context['productsPosition'] == 'body'): ?>
          <div class="block-products">
            <?php echo $item['products'] ?? ''; ?>
          </div>
        <?php endif; ?>
        <?php if ($item['manufacturers']): ?>
          <div class="block-manufacturers">
            <?php echo $item['manufacturers'] ?? ''; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
    <?php if ($item['products'] && $context['productsPosition'] == 'block'): ?>
      <div class="block-products">
        <?php echo $item['products']; ?>
      </div>
    <?php endif; ?>
    <?php
  }
endif; ?>
<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php /* grid */ ?>
    <?php if ($display == 'grid') { ?>
      <?php foreach ($items as $item): ?>
        <div class="<?php echo $journal3->classes($item['classes']); ?>">
          <?php renderCatalogBlocks(get_defined_vars(), $item); ?>
        </div>
      <?php endforeach; ?>
    <?php } ?>
    <?php /* tabs */ ?>
    <?php if ($display == 'tabs'): ?>
      <div class="tab-container <?php if ($changeTabOnHover): ?>tab-on-hover<?php endif; ?>">
        <div class="full-tabs-bg"></div>
        <ul class="nav nav-tabs">
          <?php $index = 1;
          foreach ($items as $item): ?>
            <li class="<?php echo $journal3->classes($item['tab_classes']); ?>">
              <?php if ($item['tabType'] == 'link'): ?>
                <a href="<?php echo $item['link']['href']; ?>" class="<?php if ($item['image_tab']): ?> has-image <?php endif; ?>" <?php echo $journal3->linkAttrs($item['link']); ?>><?php echo $item['title']; ?></a>
              <?php else: ?>
                <a href="#<?php echo $id; ?>-tab-<?php echo $index; ?>" class="<?php if ($item['image_tab']): ?> has-image <?php endif; ?>" data-toggle="tab">
                  <?php if ($item['image_tab']): ?>
                    <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $lazyLoad): ?>
                      <span class="menu-image"><img src="<?php echo $dummy_image; ?>" data-src="<?php echo $item['image_tab']; ?>" <?php if (isset($item['image_tab2x']) && $item['image_tab2x']): ?>data-srcset="<?php echo $item['image_tab']; ?> 1x, <?php echo $item['image_tab2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $imageDimensionsTab['width']; ?>" height="<?php echo $imageDimensionsTab['height']; ?>" class="catalog-block-image lazyload"></span>
                    <?php else: ?>
                      <span class="menu-image"><img src="<?php echo $item['image_tab']; ?>" <?php if (isset($item['image_tab2x']) && $item['image_tab2x']): ?>srcset="<?php echo $item['image_tab']; ?> 1x, <?php echo $item['image_tab2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $imageDimensionsTab['width']; ?>" height="<?php echo $imageDimensionsTab['height']; ?>" class="catalog-block-image"></span>
                    <?php endif; ?>
                  <?php endif; ?>
                  <span><?php echo $item['title']; ?></span>
                </a>
              <?php endif; ?>
              <?php if (!empty($item['href'])): ?>
              <a href="<?php echo $item['href']; ?>" class="item-all-link" title="<?php echo $allLinkText; ?>" data-toggle="tooltip-hover"><span><?php echo $allLinkText; ?></span></a>
              <?php endif; ?>
            </li>
            <?php $index++; endforeach; ?>
        </ul>
        <div class="tab-content">
          <?php $index = 1;
          foreach ($items as $item): ?>
            <?php if ($item['tabType'] != 'link'): ?>
              <div class="<?php echo $journal3->classes($item['classes']); ?>" id="<?php echo $id; ?>-tab-<?php echo $index; ?>">
                <?php renderCatalogBlocks(get_defined_vars(), $item); ?>
              </div>
            <?php endif; ?>
            <?php $index++; endforeach; ?>
        </div>
      </div>
    <?php endif; ?>
    <?php /* accordion */ ?>
    <?php if ($display == 'accordion'): ?>
      <div class="panel-group" id="<?php echo $id; ?>-collapse">
        <?php $index = 0;
        foreach ($items as $item): $index++; ?>
          <div class="<?php echo $journal3->classes($item['classes']); ?>">
            <div class="panel-heading">
              <h4 class="panel-title">
                <a href="#<?php echo $id; ?>-collapse-<?php echo $index; ?>" class="accordion-toggle collapsed <?php if ($item['image_tab']): ?> has-image <?php endif; ?>" data-toggle="collapse" data-parent="#<?php echo $id; ?>-collapse" aria-expanded="false">
                  <?php if ($item['image_tab']): ?>
                    <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $lazyLoad): ?>
                      <span class="menu-image"><img src="<?php echo $dummy_image; ?>" data-src="<?php echo $item['image_tab']; ?>" <?php if (isset($item['image_tab2x']) && $item['image_tab2x']): ?>data-srcset="<?php echo $item['image_tab']; ?> 1x, <?php echo $item['image_tab2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $imageDimensionsTab['width']; ?>" height="<?php echo $imageDimensionsTab['height']; ?>" class="catalog-block-image lazyload"></span>
                    <?php else: ?>
                      <span class="menu-image"><img src="<?php echo $item['image_tab']; ?>" <?php if (isset($item['image_tab2x']) && $item['image_tab2x']): ?>srcset="<?php echo $item['image_tab']; ?> 1x, <?php echo $item['image_tab2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $imageDimensionsTab['width']; ?>" height="<?php echo $imageDimensionsTab['height']; ?>" class="catalog-block-image"></span>
                    <?php endif; ?>
                  <?php endif; ?>
                  <span><?php echo $item['title']; ?></span>
                  <i class="fa fa-caret-down"></i>
                </a>
              </h4>
            </div>
            <div class="<?php echo $journal3->classes($item['panel_classes']); ?>" id="<?php echo $id; ?>-collapse-<?php echo $index; ?>">
              <div class="panel-body">
                <?php renderCatalogBlocks(get_defined_vars(), $item); ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
