<?php if (!function_exists('renderCatalog')) {
  function renderCatalog($context) {
    $journal3 = $context['journal3'];
    foreach ($context['items'] as $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>">
        <div class="item-content">
          <a href="<?php echo $item['href']; ?>" class="catalog-title" <?php echo $journal3->linkAttrs($item['link']); ?>><?php echo $item['name']; ?></a>
          <div class="item-assets image-left">
            <a href="<?php echo $item['href']; ?>" class="catalog-image" <?php echo $journal3->linkAttrs($item['link']); ?>>
              <?php if ($item['image']): ?>
                <?php if ($journal3->get('performanceLazyLoadImagesStatus')): ?>
                  <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $item['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>" class="lazyload">
                <?php else: ?>
                  <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x"<?php endif; ?> alt="<?php echo $item['name']; ?>" width="<?php echo $context['imageDimensions']['width']; ?>" height="<?php echo $context['imageDimensions']['height']; ?>">
                <?php endif; ?>
              <?php endif; ?>
            </a>
            <div class="subitems">
              <?php foreach ($item['items'] as $sub_item): ?>
                <div class="<?php echo $journal3->classes($sub_item['classes'] ?? null); ?> subitem" <?php if (!empty($sub_item['image'])): ?>data-image="<?php echo $sub_item['image']; ?>" data-image2x="<?php echo $sub_item['image']; ?> 1x, <?php echo $sub_item['image2x']; ?> 2x"<?php endif; ?>>
                  <a href="<?php echo $sub_item['href']; ?>" <?php echo $journal3->linkAttrs($sub_item['link'] ?? null); ?>><span><?php echo $sub_item['name']; ?></span></a>
                </div>
              <?php endforeach; ?>
              <?php if (!empty($item['total']) && ($item['total'] > count($item['items']))): ?>
                <div class="subitem view-more">
                  <a href="<?php echo $item['href']; ?>"><span><?php echo $context['viewMoreText']; ?></span></a>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach;
  }
} ?>
<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php /* grid */ ?>
    <?php if ($gridType == 'ipr' && $carousel) { ?>
      <div class="swiper" data-items-per-row='<?php echo json_encode($itemsPerRow, JSON_FORCE_OBJECT); ?>' data-options='<?php echo json_encode($carouselOptions, JSON_FORCE_OBJECT); ?>'>
        <div class="swiper-container" <?php if ($journal3->is_rtl): ?>dir="rtl"<?php endif; ?>>
          <div class="swiper-wrapper ipr-grid">
            <?php renderCatalog(get_defined_vars()); ?>
          </div>
        </div>
        <div class="swiper-buttons">
          <div class="swiper-button-prev"></div>
          <div class="swiper-button-next"></div>
        </div>
        <div class="swiper-pagination"></div>
      </div>
    <?php } else { ?>
      <div class="catalog-grid no-scroll <?php echo $gridType; ?>-grid">
        <?php if ($gridType == 'auto') { ?>
          <div class="auto-grid-items">
            <?php renderCatalog(get_defined_vars()); ?>
          </div>
          <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
          <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
        <?php } else { ?>
          <?php renderCatalog(get_defined_vars()); ?>
        <?php } ?>
      </div>
    <?php } ?>
  </div>
</div>

