<?php if ($items): ?>
  <div class="<?php echo $journal3->classes($classes); ?>">
    <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
    <ul>
      <?php foreach ($items as $item): ?>
        <li class="<?php echo $journal3->classes($item['classes']); ?>">
          <?php if ($item['link']['href']): ?>
            <a href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?>><?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?></a>
          <?php else: ?>
            <a><?php echo $journal3->countBadge($item['title'], $item['link']['total'], $item['link']['classes']); ?></a>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>
