<div class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <div class="banners-grid <?php if ($gridType == 'auto') { ?>auto-grid<?php } ?>">
      <?php if ($gridType == 'auto') { ?>
        <div class="banners-wrapper auto-grid-items">
          <?php $first_key = array_keys($items)[0]; ?>
          <?php foreach ($items as $index => $item): ?>
            <div class="<?php echo $journal3->classes($item['classes']); ?> <?php if ($first_key == $index) { ?>swiper-slide-active<?php } ?>">
              <div class="slide-content slide-content-<?php echo $item['type']; ?>">
                <?php if ($item['type'] == 'image' || $item['type'] == 'category' || $item['type'] == 'product') { ?>
                  <?php if ($lazyLoad || $first_key !== $index): ?>
                    <img class="lazyload" src="<?php echo $lazyload_placeholder; ?>" data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
                  <?php else: ?>
                    <img src="<?php echo $item['image']; ?>" srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
                  <?php endif; ?>
                <?php } else if ($item['type'] == 'video') { ?>
                  <video class="lazyload" autoplay playsinline muted loop data-src="<?php echo $item['videoSrc']; ?>" <?php if ($item['videoPoster']): ?>poster="<?php echo $item['videoPoster']; ?>"<?php endif; ?>></video>
                <?php } ?>

                <?php if ($item['link']['href']): ?>
                  <a class="slide-link" href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?> aria-hidden="true" tabindex="-1"></a>
                <?php endif; ?>

                <?php if ($item['items']) { ?>
                  <div class="slide-cols">
                    <?php foreach (['left', 'right'] as $col) { ?>
                      <?php if (!empty($item['items_' . $col])) { ?>
                        <div class="slide-col slide-col-<?php echo $col; ?>">
                          <div class="slide-layers">
                            <?php foreach ($item['items_' . $col] as $subitem): ?>
                              <?php if ($subitem['type'] == 'text'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="slide-text-layer">
                                    <div class="slide-text-item"><?php echo $subitem['text']; ?></div>
                                  </div>
                                </div>
                              <?php elseif ($subitem['type'] == 'svg'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="svg-layer"><?php echo $subitem['svg']; ?></div>
                                </div>
                              <?php elseif ($subitem['type'] == 'button'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="slide-button-group">
                                    <?php if ($subitem['button_1_text']) { ?>
                                      <a class="btn slide-button-1" <?php if ($subitem['button_1_link']['href']): ?>href="<?php echo $subitem['button_1_link']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['button_1_link']); ?><?php else: ?>href="javascript:;"<?php endif; ?>><span><?php echo $subitem['button_1_text']; ?></span></a>
                                    <?php } ?>
                                    <?php if ($subitem['button_2_text']) { ?>
                                      <a class="btn slide-button-2" <?php if ($subitem['button_2_link']['href']): ?>href="<?php echo $subitem['button_2_link']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['button_2_link']); ?><?php else: ?>href="javascript:;"<?php endif; ?>><span><?php echo $subitem['button_2_text']; ?></span></a>
                                    <?php } ?>
                                  </div>
                                </div>
                              <?php elseif ($subitem['type'] == 'image'): ?>
                                <figure class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <img class="" src="<?php echo $subitem['image']; ?>" srcset="<?php echo $subitem['image']; ?> 1x, <?php echo $subitem['image2x']; ?> 2x" alt="<?php echo $subitem['alt']; ?>" width="<?php echo $subitem['width']; ?>" height="<?php echo $subitem['height']; ?>"/>
                                  <?php if ($subitem['caption']) { ?>
                                    <figcaption><?php echo $subitem['caption']; ?></figcaption>
                                  <?php } ?>
                                  <?php if ($subitem['imageLink']['href']): ?>
                                    <a class="slide-layer-image-link" href="<?php echo $subitem['imageLink']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['imageLink']); ?> aria-hidden="true" tabindex="-1"></a>
                                  <?php endif; ?>
                                </figure>
                              <?php elseif ($subitem['type'] == 'products'): ?>
                                <div class="{{ journal3.classes(subitem.classes) }}"><?php echo $subitem['products']; ?></div>
                              <?php endif; ?>
                            <?php endforeach; ?>
                          </div>
                        </div>
                      <?php } ?>
                    <?php } ?>
                  </div>

                  <?php foreach ($item['items_absolute'] as $subitem): ?>
                    <?php if ($subitem['type'] == 'icon'): ?>
                      <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                        <div class="can-rotate">
                          <span class="has-icon"></span>
                          <?php if ($subitem['iconText']) { ?>
                            <span class="has-text"><?php echo $subitem['iconText']; ?></span>
                          <?php } ?>
                        </div>
                      </div>
                    <?php endif; ?>
                  <?php endforeach; ?>
                <?php } ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="auto-carousel-bar auto-carousel-controls">
          <div class="auto-carousel-thumb"></div>
          <div class="auto-carousel-fill"></div>
        </div>
        <div class="auto-carousel-buttons auto-carousel-controls">
          <div class="auto-carousel-prev"><span></span></div>
          <div class="auto-carousel-next"><span></span></div>
        </div>
      <?php } else { ?>
        <div class="banners-wrapper flex-grid">
          <?php $first_key = array_keys($items)[0]; ?>
          <?php foreach ($items as $index => $item): ?>
            <div class="<?php echo $journal3->classes($item['classes']); ?> <?php if ($first_key == $index) { ?>swiper-slide-active<?php } ?>">
              <div class="slide-content slide-content-<?php echo $item['type']; ?>">
                <?php if ($item['type'] == 'image' || $item['type'] == 'category' || $item['type'] == 'product') { ?>
                  <?php if ($lazyLoad || $first_key !== $index): ?>
                    <img class="lazyload" src="<?php echo $lazyload_placeholder; ?>" data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
                  <?php else: ?>
                    <img src="<?php echo $item['image']; ?>" srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>" alt="<?php echo $item['alt']; ?>" title="<?php echo $item['alt']; ?>"/>
                  <?php endif; ?>
                <?php } else if ($item['type'] == 'video') { ?>
                  <video autoplay playsinline muted data-src="<?php echo $item['videoSrc']; ?>"></video>
                <?php } ?>

                <?php if ($item['link']['href']): ?>
                  <a class="slide-link" href="<?php echo $item['link']['href']; ?>" <?php echo $journal3->linkAttrs($item['link']); ?> aria-hidden="true" tabindex="-1"></a>
                <?php endif; ?>

                <?php if ($item['items']) { ?>
                  <div class="slide-cols">
                    <?php foreach (['left', 'right'] as $col) { ?>
                      <?php if (!empty($item['items_' . $col])) { ?>
                        <div class="slide-col slide-col-<?php echo $col; ?>">
                          <slide class="layers">
                            <?php foreach ($item['items'] as $subitem): ?>
                              <?php if ($subitem['type'] == 'text'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="slide-text-layer">
                                    <div class="slide-text-item"><?php echo $subitem['text']; ?></div>
                                  </div>
                                </div>
                              <?php elseif ($subitem['type'] == 'svg'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="svg-layer"><?php echo $subitem['svg']; ?></div>
                                </div>
                              <?php elseif ($subitem['type'] == 'button'): ?>
                                <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <div class="slide-button-group">
                                    <?php if ($subitem['button_1_text']) { ?>
                                      <a class="btn slide-button-1" <?php if ($subitem['button_1_link']['href']): ?>href="<?php echo $subitem['button_1_link']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['button_1_link']); ?><?php else: ?>href="javascript:;"<?php endif; ?>><span><?php echo $subitem['button_1_text']; ?></span></a>
                                    <?php } ?>
                                    <?php if ($subitem['button_2_text']) { ?>
                                      <a class="btn slide-button-2" <?php if ($subitem['button_2_link']['href']): ?>href="<?php echo $subitem['button_2_link']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['button_2_link']); ?><?php else: ?>href="javascript:;"<?php endif; ?>><span><?php echo $subitem['button_2_text']; ?></span></a>
                                    <?php } ?>
                                  </div>
                                </div>
                              <?php elseif ($subitem['type'] == 'image'): ?>
                                <figure class="<?php echo $journal3->classes($subitem['classes']); ?>">
                                  <img class="" src="<?php echo $subitem['image']; ?>" srcset="<?php echo $subitem['image']; ?> 1x, <?php echo $subitem['image2x']; ?> 2x" alt="<?php echo $subitem['alt']; ?>" width="<?php echo $subitem['width']; ?>" height="<?php echo $subitem['height']; ?>"/>
                                  <?php if ($subitem['caption']) { ?>
                                    <figcaption><?php echo $subitem['caption']; ?></figcaption>
                                  <?php } ?>
                                  <?php if ($subitem['imageLink']['href']): ?>
                                    <a class="slide-layer-image-link" href="<?php echo $subitem['imageLink']['href']; ?>" <?php echo $journal3->linkAttrs($subitem['imageLink']); ?> aria-hidden="true" tabindex="-1"></a>
                                  <?php endif; ?>
                                </figure>
                              <?php elseif ($subitem['type'] == 'products'): ?>
                                <div class="{{ journal3.classes(subitem.classes) }}"><?php echo $subitem['products']; ?></div>
                              <?php endif; ?>
                            <?php endforeach; ?>
                          </slide>
                        </div>
                      <?php } ?>
                    <?php } ?>
                  </div>

                  <?php foreach ($item['items_absolute'] as $subitem): ?>
                    <?php if ($subitem['type'] == 'icon'): ?>
                      <div class="<?php echo $journal3->classes($subitem['classes']); ?>">
                        <div class="can-rotate">
                          <span class="has-icon"></span>
                          <?php if ($subitem['iconText']) { ?>
                            <span class="has-text"><?php echo $subitem['iconText']; ?></span>
                          <?php } ?>
                        </div>
                      </div>
                    <?php endif; ?>
                  <?php endforeach; ?>
                <?php } ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php } ?>
    </div>
  </div>
</div>
