<?php if (!function_exists('renderBanners')) {
  function renderBanners($context) {
    $journal3 = $context['journal3'];
    foreach ($context['items'] as $item): ?>
      <div class="<?php echo $journal3->classes($item['classes']); ?>">
        <a <?php if ($item['link']['href']): ?>href="<?php echo $item['link']['href']; ?>"<?php endif; ?> <?php echo $journal3->linkAttrs($item['link']); ?>>
          <?php if ($journal3->get('performanceLazyLoadImagesStatus') && $context['lazyLoad']): ?>
            <img src="<?php echo $context['dummy_image']; ?>" data-src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>data-srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>" class="lazyload"/>
          <?php else: ?>
            <img src="<?php echo $item['image']; ?>" <?php if (isset($item['image2x']) && $item['image2x']): ?>srcset="<?php echo $item['image']; ?> 1x, <?php echo $item['image2x']; ?> 2x" <?php endif; ?> alt="<?php echo $item['alt']; ?>" width="<?php echo $item['image_width']; ?>" height="<?php echo $item['image_height']; ?>"/>
          <?php endif; ?>
          <?php if ($item['title']): ?>
          <div class="banner-text banner-caption"><span><?php echo $item['title']; ?></span></div>
          <?php endif; ?>
          <?php if ($item['title2']): ?>
          <div class="banner-text banner-caption-2"><span><?php echo $item['title2']; ?></span></div>
          <?php endif; ?>
        </a>
      <?php if ($item['title3']): ?>
      <div class="banner-caption-3"><span><?php echo $item['title3']; ?></span></div>
      <?php endif; ?>
    </div>
    <?php endforeach;
  }
} ?>
<div id="<?php echo $id; ?>" class="<?php echo $journal3->classes($classes); ?>">
  <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
  <?php if ($title): ?>
    <h3 class="title module-title"><?php echo $title; ?></h3>
  <?php endif; ?>
  <div class="module-body">
    <?php /* grid */ ?>
    <?php if ($gridType == 'ipr' && $carousel) { ?>
      <div class="swiper" data-items-per-row='<?php echo json_encode($itemsPerRow, JSON_FORCE_OBJECT); ?>' data-options='<?php echo json_encode($carouselOptions, JSON_FORCE_OBJECT); ?>'>
        <div class="swiper-container" <?php if ($journal3->is_rtl): ?>dir="rtl"<?php endif; ?>>
          <div class="swiper-wrapper ipr-grid">
            <?php renderBanners(get_defined_vars()); ?>
          </div>
        </div>
        <div class="swiper-buttons">
          <div class="swiper-button-prev"></div>
          <div class="swiper-button-next"></div>
        </div>
        <div class="swiper-pagination"></div>
      </div>
    <?php } else { ?>
      <div class="banners-grid no-scroll <?php echo $gridType; ?>-grid">
        <?php if ($gridType == 'auto') { ?>
          <div class="auto-grid-items">
            <?php renderBanners(get_defined_vars()); ?>
          </div>
          <div class="auto-carousel-bar auto-carousel-controls"><div class="auto-carousel-thumb"></div><div class="auto-carousel-fill"></div></div>
          <div class="auto-carousel-buttons auto-carousel-controls"><div class="auto-carousel-prev"><span></span></div><div class="auto-carousel-next"><span></span></div></div>
        <?php } else { ?>
          <?php renderBanners(get_defined_vars()); ?>
        <?php } ?>
      </div>
    <?php } ?>
  </div>
</div>
