<?php if ($rows): ?>
  <div class="<?php echo $journal3->classes($grid_classes); ?> <?php if (count($rows) == 1) { ?>single-item<?php } ?>">
    <?php if (!empty($edit)) { ?>
    <button aria-label="Edit" class="admin-edit" type="button" data-edit="<?php echo $edit; ?>"><em class="fa fa-pencil" data-placement="auto" data-toggle="tooltip-hover" data-tooltip-class="admin-edit-tooltip" title="Edit <?php echo $name; ?>"></em></button>
    <?php } ?>
    <?php foreach ($rows as $grid_row): ?>
      <div class="<?php echo $journal3->classes($grid_row['classes']); ?>">
        <?php if (isset($grid_row['waveStatus']) && $grid_row['waveStatus']): ?>
        <svg viewBox="0 0 100 20" class="wave wave-top" preserveAspectRatio="none">
          <path fill="white" d="M 0 30 V 10 Q 25 <?php echo $grid_row['waveDirection']; ?> 55 10 T 100 10 V 30 Z"></path>
        </svg>
        <?php endif; ?>
        <div class="row-bg"></div>
        <?php if (isset($grid_row['videoBgStatus']) && $grid_row['videoBgStatus'] && (isset($grid_row['videoBg']) && $grid_row['videoBg'])): ?>
          <div class="video-row">
            <video preload="none" data-autoplay autoplay loop muted playsinline class="video-bg lazyload" data-src="<?php echo $grid_row['videoBg']; ?>"></video>
          </div>
        <?php endif; ?>
        <div class="grid-cols-wrapper">
          <div class="grid-cols <?php if (count($grid_row['columns']) == 1) { ?>single-item<?php } ?>">
            <?php foreach ($grid_row['columns'] as $grid_column): ?>
              <div class="<?php echo $journal3->classes($grid_column['classes']); ?>">
                <?php if (isset($grid_column['videoColStatus']) && $grid_column['videoColStatus'] && (isset($grid_column['videoCol']) && $grid_column['videoCol'])): ?>
                  <video preload="none" data-autoplay autoplay loop muted playsinline class="video-col-bg lazyload" data-src="<?php echo $grid_column['videoCol']; ?>"></video>
                <?php endif; ?>
                <div class="grid-items <?php if (count($grid_column['items']) == 1) { ?>single-item<?php } ?>">
                  <?php foreach ($grid_column['items'] as $grid_item): ?>
                    <div class="<?php echo $journal3->classes($grid_item['classes']); ?>"><?php echo $grid_item['item']; ?></div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
        <?php if (isset($grid_row['wave2Status']) && $grid_row['wave2Status']): ?>
        <svg viewBox="0 0 100 20" class="wave wave-bottom" preserveAspectRatio="none">
          <path fill="white" d="M 0 30 V 10 Q 25 <?php echo $grid_row['wave2Direction']; ?> 55 10 T 100 10 V 30 Z"></path>
        </svg>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
