<?php if ($journal3->get('catalogSearchStatus')) { ?>
<?php if (!function_exists('renderSearchCategories')) {
  function renderSearchCategories($context, $categories, $category_id, $index) {
    $journal3 = $context['journal3'];
    foreach ($categories as $category) {
      $classes = array('selected' => $category['category_id'] == $category_id);
      ?>
      <li data-category_id="<?php echo $category['category_id']; ?>" class="<?php echo $journal3->classes($classes); ?> category-level-<?php echo $index; ?> menu-item"><a href="javascript:;"><?php echo $category['title']; ?></a></li>
      <?php
      renderSearchCategories($context, $category['items'], $category_id, $index + 1);
    }
  }
} ?>
<div id="search" class="dropdown search-dropdown-<?php echo $journal3->get('headerMiniSearchDisplay'); ?>">
  <button class="dropdown-toggle search-trigger" data-toggle="dropdown" title="<?php echo $journal3->get('searchStyleSearchPlaceholder'); ?>"><span class="menu-icon"></span></button>
  <div class="dropdown-menu j-dropdown color-scheme-__SEARCH_COLOR_SCHEME__">
    <div class="header-search">
      <?php if ($journal3->get('searchStyleSearchCategoriesSelectorStatus') && isset($categories)) { ?>
        <div class="search-categories dropdown drop-menu">
          <div class="search-categories-button dropdown-toggle" data-toggle="dropdown"><?php echo $category_id ? $category : $journal3->get('searchStyleSearchCategories'); ?></div>
          <div class="dropdown-menu j-dropdown color-scheme-__SEARCH_CATEGORIES_COLOR_SCHEME__">
            <ul class="j-menu">
              <li data-category_id="0" class="category-level-1 menu-item"><a href="javascript:;"><?php echo $journal3->get('searchStyleSearchCategories'); ?></a></li>
              <?php renderSearchCategories(get_defined_vars(), $categories, $category_id, 1); ?>
            </ul>
          </div>
        </div>
      <?php } ?>
      <label class="sr-only" for="search-input-el"><?php echo $journal3->get('searchStyleSearchPlaceholder'); ?></label>
      <input id="search-input-el" type="search" name="search" value="<?php echo $search; ?>" placeholder="<?php echo $journal3->get('searchStyleSearchPlaceholder'); ?>" class="search-input" <?php if (isset($category_id)) { ?>data-category_id="<?php echo $category_id; ?>"<?php } ?>/>
      <button type="button" class="search-button" title="<?php echo $journal3->get('searchStyleSearchPlaceholder'); ?>"></button>
    </div>
  </div>
</div>
<?php } ?>
