<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* catalog/product_seo_list.twig */
class __TwigTemplate_a5b993047c0ccb7867886ca7fce9f574 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo ($context["header"] ?? null);
        echo ($context["column_left"] ?? null);
        echo "
<div id=\"content\">
  <div class=\"page-header\">
    <div class=\"container-fluid\">
      <div class=\"pull-right\">
      &nbsp;  
      </div>
      <h1>";
        // line 8
        echo ($context["heading_title_seo"] ?? null);
        echo "</h1>
      <ul class=\"breadcrumb\">
        ";
        // line 10
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["breadcrumbs"] ?? null));
        foreach ($context['_seq'] as $context["_key"] => $context["breadcrumb"]) {
            // line 11
            echo "        <li><a href=\"";
            echo twig_get_attribute($this->env, $this->source, $context["breadcrumb"], "href", [], "any", false, false, false, 11);
            echo "\">";
            echo twig_get_attribute($this->env, $this->source, $context["breadcrumb"], "text", [], "any", false, false, false, 11);
            echo "</a></li>
        ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['_key'], $context['breadcrumb'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 13
        echo "      </ul>
    </div>
  </div>
  <div class=\"container-fluid\">";
        // line 16
        if (($context["error_warning"] ?? null)) {
            // line 17
            echo "    <div class=\"alert alert-danger alert-dismissible\"><i class=\"fa fa-exclamation-circle\"></i> ";
            echo ($context["error_warning"] ?? null);
            echo "
      <button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>
    </div>
    ";
        }
        // line 21
        echo "    ";
        if (($context["success"] ?? null)) {
            // line 22
            echo "    <div class=\"alert alert-success alert-dismissible\"><i class=\"fa fa-check-circle\"></i> ";
            echo ($context["success"] ?? null);
            echo "
      <button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>
    </div>
    ";
        }
        // line 26
        echo "    
    <div class=\"row\">
        <div id=\"filter-product\" class=\"col-md-12 col-sm-12 hidden-sm hidden-xs\">
        <div class=\"panel panel-default\">
          <div class=\"panel-heading\">
            <h3 class=\"panel-title\"><i class=\"fa fa-filter\"></i> ";
        // line 31
        echo ($context["text_filter"] ?? null);
        echo "</h3>
          </div>
          <div class=\"panel-body\">
              
            <div class=\"row\">
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                      <label class=\"control-label\" for=\"input-name\">";
        // line 38
        echo ($context["entry_name"] ?? null);
        echo "</label>
                      <input type=\"text\" name=\"filter_name\" value=\"";
        // line 39
        echo ($context["filter_name"] ?? null);
        echo "\" placeholder=\"";
        echo ($context["entry_name"] ?? null);
        echo "\" id=\"input-name\" class=\"form-control\" />
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                      <label class=\"control-label\" for=\"input-model\">";
        // line 44
        echo ($context["entry_model"] ?? null);
        echo "</label>
                      <input type=\"text\" name=\"filter_model\" value=\"";
        // line 45
        echo ($context["filter_model"] ?? null);
        echo "\" placeholder=\"";
        echo ($context["entry_model"] ?? null);
        echo "\" id=\"input-model\" class=\"form-control\" />
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                      <label class=\"control-label\" for=\"input-status\">";
        // line 50
        echo ($context["entry_status"] ?? null);
        echo "</label>
                      <select name=\"filter_status\" id=\"input-status\" class=\"form-control\">
                        <option value=\"\"></option>
                          ";
        // line 53
        if ((($context["filter_status"] ?? null) == "1")) {
            // line 54
            echo "                        <option value=\"1\" selected=\"selected\">";
            echo ($context["text_enabled"] ?? null);
            echo "</option>
                          ";
        } else {
            // line 56
            echo "                        <option value=\"1\">";
            echo ($context["text_enabled"] ?? null);
            echo "</option>
                          ";
        }
        // line 58
        echo "                          ";
        if ((($context["filter_status"] ?? null) == "0")) {
            // line 59
            echo "                        <option value=\"0\" selected=\"selected\">";
            echo ($context["text_disabled"] ?? null);
            echo "</option>
                          ";
        } else {
            // line 61
            echo "                        <option value=\"0\">";
            echo ($context["text_disabled"] ?? null);
            echo "</option>
                          ";
        }
        // line 63
        echo "                      </select>
                    </div>
                </div>
            </div>
            <div class=\"form-group text-right\">
              <button type=\"button\" id=\"button-filter\" class=\"btn btn-default\"><i class=\"fa fa-filter\"></i> ";
        // line 68
        echo ($context["button_filter"] ?? null);
        echo "</button>
            </div>
            </div>
        </div>
      </div>
    </div>
    
    <div class=\"row\">
      <div class=\"col-md-12 col-sm-12\">
        <div class=\"panel panel-default\">
          <div class=\"panel-heading\">
            <h3 class=\"panel-title\"><i class=\"fa fa-list\"></i> ";
        // line 79
        echo ($context["text_list_seo"] ?? null);
        echo "</h3>
          </div>
          <div class=\"panel-body\">
            <form action=\"";
        // line 82
        echo ($context["delete"] ?? null);
        echo "\" method=\"post\" enctype=\"multipart/form-data\" id=\"form-product\">
              <div class=\"table-responsive\">
                <table class=\"table table-bordered table-hover\">
                  <thead>
                    <tr>
                      <td class=\"text-left\">";
        // line 87
        if ((($context["sort"] ?? null) == "pd.name")) {
            echo " <a href=\"";
            echo ($context["sort_name"] ?? null);
            echo "\" class=\"";
            echo twig_lower_filter($this->env, ($context["order"] ?? null));
            echo "\">";
            echo ($context["column_name"] ?? null);
            echo "</a> ";
        } else {
            echo " <a href=\"";
            echo ($context["sort_name"] ?? null);
            echo "\">";
            echo ($context["column_name"] ?? null);
            echo "</a> ";
        }
        echo "</td>
                      <td class=\"text-left\">";
        // line 88
        echo ($context["column_description"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 89
        echo ($context["column_focuskeyword"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 90
        echo ($context["column_meta_title"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 91
        echo ($context["column_meta_description"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 92
        echo ($context["column_meta_keyword"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 93
        echo ($context["column_seo_score"] ?? null);
        echo "</td>
                      <td class=\"text-left\">";
        // line 94
        echo ($context["column_product_strength"] ?? null);
        echo "</td>
                      <td class=\"text-right\">";
        // line 95
        echo ($context["column_action"] ?? null);
        echo "</td>
                    </tr>
                  </thead>
                  <tbody>
                  
                  ";
        // line 100
        if (($context["products"] ?? null)) {
            // line 101
            echo "                  ";
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable(($context["products"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["product"]) {
                // line 102
                echo "                  <tr>
                     <td class=\"text-left\">";
                // line 103
                echo twig_get_attribute($this->env, $this->source, $context["product"], "name", [], "any", false, false, false, 103);
                echo "</td>
                     <td>
                          ";
                // line 105
                $context["full_desc"] = twig_get_attribute($this->env, $this->source, $context["product"], "description", [], "any", false, false, false, 105);
                // line 106
                echo "                          ";
                $context["short_desc"] = twig_join_filter(twig_slice($this->env, twig_split_filter($this->env, ($context["full_desc"] ?? null), " "), 0, 30), " ");
                // line 107
                echo "                          ";
                $context["description_len"] = twig_get_attribute($this->env, $this->source, $context["product"], "description_length", [], "any", false, false, false, 107);
                // line 108
                echo "                          <small style=\"color:";
                echo (((($context["description_len"] ?? null) < 150)) ? ("red") : ("green"));
                echo ";\">
                            Length: ";
                // line 109
                echo ($context["description_len"] ?? null);
                echo " chars (Recommended: 150+)
                          </small>
                          <br>
                          ";
                // line 112
                if (twig_get_attribute($this->env, $this->source, $context["product"], "focus_in_description", [], "any", false, false, false, 112)) {
                    // line 113
                    echo "                            <small style=\"color:green;\">Focus Keyword found in Description</small>
                          ";
                } else {
                    // line 115
                    echo "                            <small style=\"color:red;\">Focus Keyword missing from Description</small>
                          ";
                }
                // line 117
                echo "                        </td>
                    <td class=\"text-left\">";
                // line 118
                echo twig_get_attribute($this->env, $this->source, $context["product"], "focus_keyword", [], "any", false, false, false, 118);
                echo "</td>
                    <td>
                      ";
                // line 120
                echo twig_get_attribute($this->env, $this->source, $context["product"], "meta_title", [], "any", false, false, false, 120);
                echo "
                      <br>
                      ";
                // line 122
                $context["mt_len"] = twig_length_filter($this->env, twig_get_attribute($this->env, $this->source, $context["product"], "meta_title", [], "any", false, false, false, 122));
                // line 123
                echo "                      <small style=\"color:";
                echo ((((($context["mt_len"] ?? null) < 50) || (($context["mt_len"] ?? null) > 60))) ? ("red") : ("green"));
                echo ";\">
                        Length: ";
                // line 124
                echo ($context["mt_len"] ?? null);
                echo " chars (Recommended: 50–60)
                      </small>
                    </td>
                    <td>
                      ";
                // line 128
                echo twig_get_attribute($this->env, $this->source, $context["product"], "meta_description", [], "any", false, false, false, 128);
                echo "
                      <br>
                      ";
                // line 130
                $context["md_len"] = twig_length_filter($this->env, twig_get_attribute($this->env, $this->source, $context["product"], "meta_description", [], "any", false, false, false, 130));
                // line 131
                echo "                      <small style=\"color:";
                echo ((((($context["md_len"] ?? null) < 120) || (($context["md_len"] ?? null) > 160))) ? ("red") : ("green"));
                echo ";\">
                        Length: ";
                // line 132
                echo ($context["md_len"] ?? null);
                echo " chars (Recommended: 120–160)
                      </small>
                    </td>
                    <td>";
                // line 135
                echo twig_get_attribute($this->env, $this->source, $context["product"], "meta_keyword", [], "any", false, false, false, 135);
                echo "</td>
                    
                    <td>
                      <button type=\"button\" class=\"btn btn-warning btn-sm view-seo-issues\"
                            data-toggle=\"modal\"
                            data-target=\"#productSeoScorehModal\"
                            data-issues='";
                // line 141
                echo twig_escape_filter($this->env, json_encode(twig_get_attribute($this->env, $this->source, $context["product"], "product_seo_details", [], "any", false, false, false, 141)), "html_attr");
                echo "'>
                            ";
                // line 142
                echo twig_get_attribute($this->env, $this->source, $context["product"], "product_seo_total_score", [], "any", false, false, false, 142);
                echo "/";
                echo twig_get_attribute($this->env, $this->source, $context["product"], "product_seo_out_of", [], "any", false, false, false, 142);
                echo "
                        </button>
                    </td>
                    
                    <td>
                      <button type=\"button\" class=\"btn btn-warning btn-sm view-product-strngth-issues\"
                            data-toggle=\"modal\"
                            data-target=\"#productStrengthModal\"
                            data-issues='";
                // line 150
                echo twig_escape_filter($this->env, json_encode(twig_get_attribute($this->env, $this->source, $context["product"], "product_strength_details", [], "any", false, false, false, 150)), "html_attr");
                echo "'>
                            ";
                // line 151
                echo twig_get_attribute($this->env, $this->source, $context["product"], "product_strength_total_score", [], "any", false, false, false, 151);
                echo "/";
                echo twig_get_attribute($this->env, $this->source, $context["product"], "product_strength_out_of", [], "any", false, false, false, 151);
                echo "
                        </button>
                      ";
                // line 153
                if ((twig_get_attribute($this->env, $this->source, $context["product"], "product_strength_total_score", [], "any", false, false, false, 153) >= 80)) {
                    // line 154
                    echo "                        <span style=\"color:green;\">Good</span>
                      ";
                } elseif ((twig_get_attribute($this->env, $this->source,                 // line 155
$context["product"], "product_strength_total_score", [], "any", false, false, false, 155) >= 50)) {
                    // line 156
                    echo "                        <span style=\"color:orange;\">Average</span>
                      ";
                } else {
                    // line 158
                    echo "                        <span style=\"color:red;\">Poor</span>
                      ";
                }
                // line 160
                echo "                    </td>
                    
                    <td class=\"text-right\">
                        <div style=\"min-width: 120px;\">
                          <div class=\"btn-group\"> <a href=\"";
                // line 164
                echo twig_constant("HTTP_CATALOG");
                echo "?route=product/product&product_id=";
                echo twig_get_attribute($this->env, $this->source, $context["product"], "product_id", [], "any", false, false, false, 164);
                echo "\" target=\"_blank\" data-toggle=\"tooltip\" title=\"";
                echo ($context["button_view"] ?? null);
                echo "\" class=\"btn btn-primary\"><i class=\"fa fa-eye\"></i></a>
                            <button type=\"button\" data-toggle=\"dropdown\" class=\"btn btn-primary dropdown-toggle\"><span class=\"caret\"></span></button>
                            <ul class=\"dropdown-menu dropdown-menu-right\">
                              <li><a href=\"";
                // line 167
                echo twig_get_attribute($this->env, $this->source, $context["product"], "edit", [], "any", false, false, false, 167);
                echo "\" target=\"_blank\"><i class=\"fa fa-pencil\"></i> ";
                echo ($context["button_edit"] ?? null);
                echo "</a></li>
                              <li><a href=\"";
                // line 168
                echo twig_get_attribute($this->env, $this->source, $context["product"], "google_search", [], "any", false, false, false, 168);
                echo "\" target=\"_blank\"><i class=\"fa fa-search\"></i> Search Google</a></li>
                              <li><a href=\"";
                // line 169
                echo twig_get_attribute($this->env, $this->source, $context["product"], "google_index_check", [], "any", false, false, false, 169);
                echo "\" target=\"_blank\"><i class=\"fa fa-globe\"></i> Check Google Index</a></li>
                            </ul>
                          </div>
                        </div>
                    </td>
                    
                  </tr>
                  ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['product'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 177
            echo "                  ";
        } else {
            // line 178
            echo "                  <tr>
                    <td class=\"text-center\" colspan=\"8\">";
            // line 179
            echo ($context["text_no_results"] ?? null);
            echo "</td>
                  </tr>
                  ";
        }
        // line 182
        echo "                    </tbody>
                  
                </table>
              </div>
            </form>
            <div class=\"row\">
              <div class=\"col-sm-6 text-left\">";
        // line 188
        echo ($context["pagination"] ?? null);
        echo "</div>
              <div class=\"col-sm-6 text-right\">";
        // line 189
        echo ($context["results"] ?? null);
        echo "</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  

<div class=\"modal fade\" id=\"productSeoScorehModal\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"productSeoScorehModalLabel\" aria-hidden=\"true\">
  <div class=\"modal-dialog modal-lg\" role=\"document\">
    <div class=\"modal-content\">
      <div class=\"modal-header\">
        <h5 class=\"modal-title\" id=\"productSeoScorehModalLabel\">SEO Score</h5>
        <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\">
          <span aria-hidden=\"true\">&times;</span>
        </button>
      </div>
      <div class=\"modal-body\">
        <table class=\"table table-bordered table-striped\">
          <thead>
            <tr>
              <th>#</th>
              <th>Check</th>
              <th>Score</th>
              <th>Out Of</th>
              <th>Issue</th>
            </tr>
          </thead>
          <tbody id=\"seo-details-body\">
            <!-- JS will populate this -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>


  <div class=\"modal fade\" id=\"productStrengthModal\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"productStrengthModalLabel\" aria-hidden=\"true\">
  <div class=\"modal-dialog modal-lg\" role=\"document\">
    <div class=\"modal-content\">
      <div class=\"modal-header\">
        <h5 class=\"modal-title\" id=\"productStrengthModalLabel\">Product Strength</h5>
        <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\">
          <span aria-hidden=\"true\">&times;</span>
        </button>
      </div>
      <div class=\"modal-body\">
        <table class=\"table table-bordered table-striped\">
          <thead>
            <tr>
              <th>#</th>
              <th>Check</th>
              <th>Score</th>
              <th>Out Of</th>
              <th>Issue</th>
            </tr>
          </thead>
          <tbody id=\"product-strength-body\">
            <!-- JS will populate this -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const buttons = document.querySelectorAll('.view-product-strngth-issues');

  buttons.forEach(button => {
    button.addEventListener('click', function () {
      const data = this.getAttribute('data-issues');
      let details = [];

      try {
        details = JSON.parse(data);
      } catch (e) {
        alert('Failed to parse SEO details.');
        return;
      }

      const tbody = document.getElementById('product-strength-body');
      tbody.innerHTML = '';

      if (details.length === 0) {
        tbody.innerHTML = '<tr><td colspan=\"5\">No details available.</td></tr>';
        return;
      }

      details.forEach((item, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>\${index + 1}</td>
          <td>\${item.label}</td>
          <td>\${item.earned}</td>
          <td>\${item.max}</td>
          <td>\${item.note ?? '-'}</td>
        `;
        tbody.appendChild(tr);
      });
    });
  });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const buttons = document.querySelectorAll('.view-seo-issues');

  buttons.forEach(button => {
    button.addEventListener('click', function () {
      const data = this.getAttribute('data-issues');
      let details = [];

      try {
        details = JSON.parse(data);
      } catch (e) {
        alert('Failed to parse SEO details.');
        return;
      }

      const tbody = document.getElementById('seo-details-body');
      tbody.innerHTML = '';

      if (details.length === 0) {
        tbody.innerHTML = '<tr><td colspan=\"5\">No details available.</td></tr>';
        return;
      }

      details.forEach((item, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>\${index + 1}</td>
          <td>\${item.title}</td>
          <td>\${item.score}</td>
          <td>\${item.out_of}</td>
          <td>\${item.issue ?? '-'}</td>
        `;
        tbody.appendChild(tr);
      });
    });
  });
});
</script>
  
  <script type=\"text/javascript\"><!--
\$('#button-filter').on('click', function() {
\tvar url = '';

\tvar filter_name = \$('input[name=\\'filter_name\\']').val();

\tif (filter_name) {
\t\turl += '&filter_name=' + encodeURIComponent(filter_name);
\t}

\tvar filter_model = \$('input[name=\\'filter_model\\']').val();

\tif (filter_model) {
\t\turl += '&filter_model=' + encodeURIComponent(filter_model);
\t}

\tvar filter_price = \$('input[name=\\'filter_price\\']').val();

\tif (filter_price) {
\t\turl += '&filter_price=' + encodeURIComponent(filter_price);
\t}

\tvar filter_quantity = \$('input[name=\\'filter_quantity\\']').val();

\tif (filter_quantity) {
\t\turl += '&filter_quantity=' + encodeURIComponent(filter_quantity);
\t}

\tvar filter_status = \$('select[name=\\'filter_status\\']').val();

\tif (filter_status !== '') {
\t\turl += '&filter_status=' + encodeURIComponent(filter_status);
\t}

\tlocation = 'index.php?route=catalog/product/seo&user_token=";
        // line 371
        echo ($context["user_token"] ?? null);
        echo "' + url;
});
//--></script> 
  <script type=\"text/javascript\"><!--
// IE and Edge fix!
\$('button[form=\\'form-product\\']').on('click', function(e) {
\t\$('#form-product').attr('action', \$(this).attr('formaction'));
});
  
\$('input[name=\\'filter_name\\']').autocomplete({
\t'source': function(request, response) {
\t\t\$.ajax({
\t\t\turl: 'index.php?route=catalog/product/autocomplete&user_token=";
        // line 383
        echo ($context["user_token"] ?? null);
        echo "&filter_name=' +  encodeURIComponent(request),
\t\t\tdataType: 'json',
\t\t\tsuccess: function(json) {
\t\t\t\tresponse(\$.map(json, function(item) {
\t\t\t\t\treturn {
\t\t\t\t\t\tlabel: item['name'],
\t\t\t\t\t\tvalue: item['product_id']
\t\t\t\t\t}
\t\t\t\t}));
\t\t\t}
\t\t});
\t},
\t'select': function(item) {
\t\t\$('input[name=\\'filter_name\\']').val(item['label']);
\t}
});

\$('input[name=\\'filter_model\\']').autocomplete({
\t'source': function(request, response) {
\t\t\$.ajax({
\t\t\turl: 'index.php?route=catalog/product/autocomplete&user_token=";
        // line 403
        echo ($context["user_token"] ?? null);
        echo "&filter_model=' +  encodeURIComponent(request),
\t\t\tdataType: 'json',
\t\t\tsuccess: function(json) {
\t\t\t\tresponse(\$.map(json, function(item) {
\t\t\t\t\treturn {
\t\t\t\t\t\tlabel: item['model'],
\t\t\t\t\t\tvalue: item['product_id']
\t\t\t\t\t}
\t\t\t\t}));
\t\t\t}
\t\t});
\t},
\t'select': function(item) {
\t\t\$('input[name=\\'filter_model\\']').val(item['label']);
\t}
});
//--></script>
</div>
";
        // line 421
        echo ($context["footer"] ?? null);
        echo " ";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "catalog/product_seo_list.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  712 => 421,  691 => 403,  668 => 383,  653 => 371,  468 => 189,  464 => 188,  456 => 182,  450 => 179,  447 => 178,  444 => 177,  430 => 169,  426 => 168,  420 => 167,  410 => 164,  404 => 160,  400 => 158,  396 => 156,  394 => 155,  391 => 154,  389 => 153,  382 => 151,  378 => 150,  365 => 142,  361 => 141,  352 => 135,  346 => 132,  341 => 131,  339 => 130,  334 => 128,  327 => 124,  322 => 123,  320 => 122,  315 => 120,  310 => 118,  307 => 117,  303 => 115,  299 => 113,  297 => 112,  291 => 109,  286 => 108,  283 => 107,  280 => 106,  278 => 105,  273 => 103,  270 => 102,  265 => 101,  263 => 100,  255 => 95,  251 => 94,  247 => 93,  243 => 92,  239 => 91,  235 => 90,  231 => 89,  227 => 88,  209 => 87,  201 => 82,  195 => 79,  181 => 68,  174 => 63,  168 => 61,  162 => 59,  159 => 58,  153 => 56,  147 => 54,  145 => 53,  139 => 50,  129 => 45,  125 => 44,  115 => 39,  111 => 38,  101 => 31,  94 => 26,  86 => 22,  83 => 21,  75 => 17,  73 => 16,  68 => 13,  57 => 11,  53 => 10,  48 => 8,  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "catalog/product_seo_list.twig", "");
    }
}
