<?php
class ControllerExtensionDashboardQuickSearch extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/dashboard/quick_search');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('dashboard_quick_search', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/dashboard/quick_search', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/dashboard/quick_search', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

        if (isset($this->request->post['dashboard_quick_search_width'])) {
            $data['dashboard_quick_search_width'] = $this->request->post['dashboard_quick_search_width'];
        } else {
            $data['dashboard_quick_search_width'] = $this->config->get('dashboard_quick_search_width');
        }
    
        $data['columns'] = array();
        
        for ($i = 3; $i <= 12; $i++) {
            $data['columns'][] = $i;
        }
                
        if (isset($this->request->post['dashboard_quick_search_status'])) {
            $data['dashboard_quick_search_status'] = $this->request->post['dashboard_quick_search_status'];
        } else {
            $data['dashboard_quick_search_status'] = $this->config->get('dashboard_quick_search_status');
        }

        if (isset($this->request->post['dashboard_quick_search_sort_order'])) {
            $data['dashboard_quick_search_sort_order'] = $this->request->post['dashboard_quick_search_sort_order'];
        } else {
            $data['dashboard_quick_search_sort_order'] = $this->config->get('dashboard_quick_search_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/dashboard/quick_search_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/dashboard/quick_search')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
    
    public function dashboard() {
        $this->load->language('extension/dashboard/quick_search');
        $this->load->model('extension/dashboard/quick_search');

        $data['heading_title'] = $this->language->get('heading_title');
        
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }
        
        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = '';
        }
        
        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = '';
        }
        
        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = '';
        }
        
        if (isset($this->request->get['filter_customer_telephone'])) {
            $filter_customer_telephone = $this->request->get['filter_customer_telephone'];
        } else {
            $filter_customer_telephone = '';
        }
        
        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }
        
        if (isset($this->request->get['filter_product'])) {
            $filter_product = $this->request->get['filter_product'];
        } else {
            $filter_product = '';
        }
        
        $data['filter_pname'] = '';
        $data['filter_cname'] = '';
        $data['filter_pmanufacturer'] = '';
        $data['filter_customer_name'] = '';
        $data['filter_customer_email'] = '';
        $data['filter_orderid'] = '';
        $data['filter_orderbycustomer'] = '';
        $data['filter_customer_telephone'] = '';
        $data['filter_orderbycustomertel'] = '';
        if(isset($this->request->get['route'])){
            if($this->request->get['route'] == 'catalog/product'){
                if(!empty($filter_name)){
                    $data['filter_pname'] = $filter_name;
                }
                
            }
            
            if($this->request->get['route'] == 'catalog/category'){
                if(!empty($filter_name)){
                    $data['filter_cname'] = $filter_name;
                }
            }
            
            if($this->request->get['route'] == 'catalog/manufacturer'){
                if(!empty($filter_name)){
                    $data['filter_pmanufacturer'] = $filter_name;
                }
            }
            
            
            if($this->request->get['route'] == 'customer/customer'){
                if(!empty($filter_name)){
                    $data['filter_customer_name'] = $filter_name;
                }
                
                if(!empty($filter_email)){
                    $data['filter_customer_email'] = $filter_email;
                }
                
                if(!empty($filter_telephone)){
                    $data['filter_customer_telephone'] = $filter_telephone;
                }
            }
            
            if($this->request->get['route'] == 'sale/order'){
                if(!empty($filter_order_id)){
                    $data['filter_orderid'] = $filter_order_id;
                }
                
                if(!empty($filter_customer)){
                    $data['filter_orderbycustomer'] = $filter_customer;
                }
                
                if(!empty($filter_telephone)){
                    $data['filter_orderbycustomertel'] = $filter_telephone;
                }
            }
            
        }
        
        $data['user_token'] = isset($this->session->data['user_token']) ? $this->session->data['user_token'] : '';
        
        return $this->load->view('extension/dashboard/quick_search', $data);
    }
}
