<?php
function valid($form_data) {
    $config_name = isset($form_data['config_name']) ? $form_data['config_name'] : '';
    $config_owner = isset($form_data['config_owner']) ? $form_data['config_owner'] : '';
    $config_address = isset($form_data['config_address']) ? $form_data['config_address'] : '';
    $config_email = isset($form_data['config_email']) ? $form_data['config_email'] : '';
    $config_telephone = isset($form_data['config_telephone']) ? $form_data['config_telephone'] : '';
    $license_code = isset($form_data['ac5_key']) ? $form_data['ac5_key'] : '';
    
    $post_data = [
        'store_name'    => $config_name,
        'store_owner'   => $config_owner,
        'address'       => $config_address,
        'email'         => $config_email,
        'telephone'     => $config_telephone,
        'domain'        => $_SERVER['SERVER_NAME'],
        'api_key'       => 'a1d902b6213ac8e34fd5d5e8a97e8d88', // Your fixed API Key
        'license_code' => $license_code,
        'ip_address'    => getUserIP(),
    ];

    $response = call_license_api('api/license/validate', $post_data);

    return $response;
}

function call_license_api($endpoint, $post_data) {
    $api_url = 'https://www.againtheme.com/index.php?route=';
    $full_url = $api_url . $endpoint;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $full_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        return ['status' => false, 'message' => 'cURL error: ' . $error_msg];
    }

    curl_close($ch);

    return json_decode($response, true);
}

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}
?>