<?php
class ControllerExtensionDashboardTopView extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/dashboard/top_view');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('dashboard_top_view', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/dashboard/top_view', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/dashboard/top_view', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

        if (isset($this->request->post['dashboard_top_view_width'])) {
            $data['dashboard_top_view_width'] = $this->request->post['dashboard_top_view_width'];
        } else {
            $data['dashboard_top_view_width'] = $this->config->get('dashboard_top_view_width');
        }
    
        $data['columns'] = array();
        
        for ($i = 3; $i <= 12; $i++) {
            $data['columns'][] = $i;
        }
                
        if (isset($this->request->post['dashboard_top_view_status'])) {
            $data['dashboard_top_view_status'] = $this->request->post['dashboard_top_view_status'];
        } else {
            $data['dashboard_top_view_status'] = $this->config->get('dashboard_top_view_status');
        }

        if (isset($this->request->post['dashboard_top_view_sort_order'])) {
            $data['dashboard_top_view_sort_order'] = $this->request->post['dashboard_top_view_sort_order'];
        } else {
            $data['dashboard_top_view_sort_order'] = $this->config->get('dashboard_top_view_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/dashboard/top_view_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/dashboard/top_view')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
    
    public function dashboard() {
        
        $this->load->language('extension/dashboard/top_view');

        $data['heading_title'] = $this->language->get('heading_title');
        
        $results = $this->db->query("
            SELECT p.product_id, p.image, p.quantity, p.viewed, pd.name, p.stock_status_id, ss.name AS stock_status 
            FROM " . DB_PREFIX . "product p 
            LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "') 
            LEFT JOIN " . DB_PREFIX . "stock_status ss ON (p.stock_status_id = ss.stock_status_id AND ss.language_id = '" . (int)$this->config->get('config_language_id') . "') 
            ORDER BY p.viewed DESC 
            LIMIT 5
        ");
        
        $data['products'] = [];
        $this->load->model('tool/image');
        foreach ($results->rows as $result) {
            $image = $result['image'] && is_file(DIR_IMAGE . $result['image']) ?
                $this->model_tool_image->resize($result['image'], 40, 40) :
                $this->model_tool_image->resize('no_image.png', 40, 40);

            $data['products'][] = [
                'product_id'   => $result['product_id'],
                'name'         => $result['name'],
                'viewed'       => $result['viewed'],
                'image'        => $image,
                'stock_status' => $result['stock_status']
            ];
        }

        return $this->load->view('extension/dashboard/top_view', $data);
    }
}
