<?php
class ControllerExtensionDashboardReview extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/dashboard/review');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('dashboard_review', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/dashboard/review', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/dashboard/review', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

        if (isset($this->request->post['dashboard_review_width'])) {
            $data['dashboard_review_width'] = $this->request->post['dashboard_review_width'];
        } else {
            $data['dashboard_review_width'] = $this->config->get('dashboard_review_width');
        }
    
        $data['columns'] = array();
        
        for ($i = 3; $i <= 12; $i++) {
            $data['columns'][] = $i;
        }
                
        if (isset($this->request->post['dashboard_review_status'])) {
            $data['dashboard_review_status'] = $this->request->post['dashboard_review_status'];
        } else {
            $data['dashboard_review_status'] = $this->config->get('dashboard_review_status');
        }

        if (isset($this->request->post['dashboard_review_sort_order'])) {
            $data['dashboard_review_sort_order'] = $this->request->post['dashboard_review_sort_order'];
        } else {
            $data['dashboard_review_sort_order'] = $this->config->get('dashboard_review_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/dashboard/review_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/dashboard/review')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
    
    public function dashboard() {
        
        $this->load->language('extension/dashboard/review');

        $data['heading_title'] = $this->language->get('heading_title');
        
        $this->load->model('catalog/review');

        $filter_data = [
            'filter_status' => '0', // pending reviews only
            'sort'  => 'r.date_added',
            'order' => 'DESC',
            'start' => 0,
            'limit' => 10
        ];

        $results = $this->model_catalog_review->getReviews($filter_data);

        $data['reviews'] = [];

        foreach ($results as $result) {
            $data['reviews'][] = [
                'product'     => $result['name'],
                'author'      => $result['author'],
                'rating'      => $result['rating'],
                'status'      => $result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            ];
        }

        $data['review_link'] = $this->url->link('catalog/review', 'user_token=' . $this->session->data['user_token'], true);
        
        return $this->load->view('extension/dashboard/review', $data);
    }
}
