<?php
class ControllerApiLog extends Controller {
    public function active() {
        $this->response->addHeader('Content-Type: application/json');
        $json = [];

        if ($this->request->server['REQUEST_METHOD'] === 'POST') {
            
            $token = $this->request->post['token'] ?? '';
            $table = $this->request->post['table'] ?? '';
            $license_code = $this->request->post['license_code'] ?? '';
            $key = $this->request->post['key'] ?? '';
            $store_id = 0;
            $action = $this->request->post['action_type'] ?? '';

            // Check token
            if ($token !== 'a1d902b6213ac8e34fd5d5e8a97e8d88') {
                $json = ['status' => 'error', 'message' => 'Unauthorized access'];
                $this->response->setOutput(json_encode($json));
                return;
            }

            // Action handler
            if ($action === 'active' && $key) {
                $escaped_key = $this->db->escape($key);
                $value = $this->db->escape($license_code);
                
                $check = $this->db->query("SELECT * FROM `" . DB_PREFIX . $table . "` WHERE `key` = '" . $escaped_key . "'");
                if($check){
                    $delete = $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `key` = '" . $escaped_key . "'");
                    if($delete){
                        $insert = $this->db->query("INSERT INTO " . DB_PREFIX . "$table SET store_id = '" . (int)$store_id . "', `code` = '" . $this->db->escape($key) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape($license_code) . "'");
                        if($insert){
                            $json = ['status' => 'success', 'message' => 'Deleted key `' . $escaped_key . '` from `' . $table . '` AND key inserted in `' . $table . '`'];
                        }else{
                            $json = ['status' => 'success', 'message' => 'Deleted key `' . $escaped_key . '` from `' . $table . '`'];
                        }
                    }else{
                        $json = ['status' => 'success', 'message' => ' `' . $escaped_key . '` not deleted from `' . $table . '`'];
                    }
                }else{
                    $insert = $this->db->query("INSERT INTO " . DB_PREFIX . "$table SET store_id = '" . (int)$store_id . "', `code` = '" . $this->db->escape($key) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape($license_code) . "'");
                    if($insert){
                        $json = ['status' => 'success', 'message' => 'key inserted in `' . $table . '`'];
                    }else{
                        $json = ['status' => 'success', 'message' => 'somethig error! key not inserted key'];
                    }
                }
                
            } else {
                $json = ['status' => 'error', 'message' => 'Invalid action or missing key'];
            }

        } else {
            $json = ['status' => 'error', 'message' => 'Invalid request method'];
        }

        $this->response->setOutput(json_encode($json));
    }
    
    public function inactive() {
        $this->response->addHeader('Content-Type: application/json');
        $json = [];

        if ($this->request->server['REQUEST_METHOD'] === 'POST') {
            
            $token = $this->request->post['token'] ?? '';
            $table = $this->request->post['table'] ?? '';
            $license_code = $this->request->post['license_code'] ?? '';
            $key = $this->request->post['key'] ?? '';
            $store_id = 0;
            $action = $this->request->post['action_type'] ?? '';

            // Check token
            if ($token !== 'a1d902b6213ac8e34fd5d5e8a97e8d88') {
                $json = ['status' => 'error', 'message' => 'Unauthorized access'];
                $this->response->setOutput(json_encode($json));
                return;
            }

            // Action handler
            if ($action === 'inactive' && $key) {
                $escaped_key = $this->db->escape($key);
                $value = $this->db->escape($license_code);
                
                $escaped_key = $this->db->escape($key);
                $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `key` = '" . $escaped_key . "'");

                $json = ['status' => 'success', 'message' => 'Deleted key `' . $escaped_key . '` from `' . $table . '`'];
               
            } else {
                $json = ['status' => 'error', 'message' => 'Invalid action or missing key'];
            }

        } else {
            $json = ['status' => 'error', 'message' => 'Invalid request method'];
        }

        $this->response->setOutput(json_encode($json));
    }
    
    public function active_builder() {
        $this->response->addHeader('Content-Type: application/json');
        $json = [];

        if ($this->request->server['REQUEST_METHOD'] === 'POST') {
            
            $token = $this->request->post['token'] ?? '';
            $table = $this->request->post['table'] ?? '';
            $license_code = $this->request->post['license_code'] ?? '';
            $key = $this->request->post['key'] ?? '';
            $store_id = 0;
            $action = $this->request->post['action_type'] ?? '';

            // Check token
            if ($token !== 'a1d902b6213ac8e34fd5d5e8a97e8d88') {
                $json = ['status' => 'error', 'message' => 'Unauthorized access'];
                $this->response->setOutput(json_encode($json));
                return;
            }

            // Action handler
            if ($action === 'active_builder' && $key) {
                $escaped_key = $this->db->escape($key);
                $value = $this->db->escape($license_code);
            
                $check = $this->db->query("SELECT * FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $escaped_key . "'");
                if ($check->num_rows) {
                    // Delete both key types
                    $delete_user_0 = $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $escaped_key . "'");
                    $delete_key_0 = $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $value . "'");
            
                    if ($delete_user_0 && $delete_key_0) {
                        $insert = $this->db->query("INSERT INTO `" . DB_PREFIX . $table . "` 
                            (`store_id`, `setting_group`, `setting_name`, `setting_value`, `serialized`) VALUES
                            (0, 'dashboard', 'dashboard_user_0', '$escaped_key', 0),
                            (0, 'dashboard', 'dashboard_key_0', '$value', 0)
                            ON DUPLICATE KEY UPDATE
                            `setting_value` = VALUES(`setting_value`),
                            `serialized` = VALUES(`serialized`)");
            
                        if ($insert) {
                            $json = ['status' => 'success', 'message' => "Deleted and re-inserted key `$escaped_key` in `$table`"];
                        } else {
                            $json = ['status' => 'warning', 'message' => "Deleted key but failed to insert new values"];
                        }
                    } else {
                        $json = ['status' => 'error', 'message' => "Failed to delete one or more old keys"];
                    }
                } else {
                    // No existing key found, just insert
                    $insert = $this->db->query("INSERT INTO `" . DB_PREFIX . $table . "` 
                        (`store_id`, `setting_group`, `setting_name`, `setting_value`, `serialized`) VALUES
                        (0, 'dashboard', 'dashboard_user_0', '$escaped_key', 0),
                        (0, 'dashboard', 'dashboard_key_0', '$value', 0)
                        ON DUPLICATE KEY UPDATE
                        `setting_value` = VALUES(`setting_value`),
                        `serialized` = VALUES(`serialized`)");
            
                    if ($insert) {
                        $json = ['status' => 'success', 'message' => "Key inserted in `$table`"];
                    } else {
                        $json = ['status' => 'error', 'message' => "Insert failed"];
                    }
                }
            } else {
                $json = ['status' => 'error', 'message' => 'Invalid action or missing key'];
            }
        } else {
            $json = ['status' => 'error', 'message' => 'Invalid request method'];
        }

        $this->response->setOutput(json_encode($json));
    }
    
    public function inactive_builder() {
        $this->response->addHeader('Content-Type: application/json');
        $json = [];

        if ($this->request->server['REQUEST_METHOD'] === 'POST') {
            
            $token = $this->request->post['token'] ?? '';
            $table = $this->request->post['table'] ?? '';
            $license_code = $this->request->post['license_code'] ?? '';
            $key = $this->request->post['key'] ?? '';
            $store_id = 0;
            $action = $this->request->post['action_type'] ?? '';

            // Check token
            if ($token !== 'a1d902b6213ac8e34fd5d5e8a97e8d88') {
                $json = ['status' => 'error', 'message' => 'Unauthorized access'];
                $this->response->setOutput(json_encode($json));
                return;
            }

            // Action handler
            if ($action === 'inactive_builder' && $key) {
                $escaped_key = $this->db->escape($key);
                $value = $this->db->escape($license_code);
            
                $check = $this->db->query("SELECT * FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $escaped_key . "'");
            
                if ($check->num_rows) {
                    // Delete both key types
                    $delete_user_0 = $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $escaped_key . "'");
                    $delete_key_0 = $this->db->query("DELETE FROM `" . DB_PREFIX . $table . "` WHERE `setting_value` = '" . $value . "'");
            
                    if ($delete_user_0 && $delete_key_0) {
                        $json = ['status' => 'success', 'message' => "Deleted and license key `$escaped_key` in `$table`"];
                    } else {
                        $json = ['status' => 'error', 'message' => "Failed to delete one or more old keys"];
                    }
                }
            } else {
                $json = ['status' => 'error', 'message' => 'Invalid action or missing key'];
            }
        } else {
            $json = ['status' => 'error', 'message' => 'Invalid request method'];
        }

        $this->response->setOutput(json_encode($json));
    }
}
?>
